<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\backend\LoginController;
use App\Http\Controllers\backend\ForgotPasswordController;
use App\Http\Controllers\backend\ServiceController;
use App\Http\Controllers\backend\BannerController;
use App\Http\Controllers\backend\AgentController;
use App\Http\Controllers\backend\LeadsController;
use App\Http\Controllers\backend\HotLeadsController;
use App\Http\Controllers\backend\NotificationController;
use App\Http\Controllers\WebNotification;
use App\Http\Controllers\backend\FAQController;
use App\Http\Controllers\backend\TutorialLinkController;
use App\Http\Controllers\QRCodeController;
use App\Http\Controllers\backend\LoanController;
/* 
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/enquiries/{employee_id}', [QRCodeController::class, 'enquiries'])->name('enquiries');
Route::get('/generate-qrcode', [QRCodeController::class, 'generateQRCode'])->name('generate.qrcode');
Route::post('/save/enquiries', [QRCodeController::class, 'saveEnquiries'])->name('save.enquiries');
Route::get("/success", function () {
    return view("success");
})->name('success');

Route::group(
    ['namespace' => 'Admin', 'as' => 'admin.'],
    function () {
        Route::get('/', [LoginController::class, 'index'])->name('login');

        Route::post('/login', [LoginController::class, 'postLogin'])->name('adminLoginPost');
        Route::get('/logout', [LoginController::class, 'adminLogout'])->name('logout');
        Route::get('/reset-password', [LoginController::class, 'resetPassword'])->name('reset-password');
        Route::post('/update-password', [LoginController::class, 'updatePassword'])->name('update-password');

        Route::get('/forget-password', [ForgotPasswordController::class, 'showForgetPasswordForm'])->name('forget-password-get');
        Route::post('/forget-password', [ForgotPasswordController::class, 'submitForgetPasswordForm'])->name('forget.password.post');
        Route::get('/reset-password/{token}', [ForgotPasswordController::class, 'showResetPasswordForm'])->name('reset.password.get');
        Route::post('/reset-password', [ForgotPasswordController::class, 'submitResetPasswordForm'])->name('reset.password.post');




        Route::group(['middleware' => 'adminauth'], function () {
            Route::get('/dashboard', [LoginController::class, 'dashboard'])->name('adminDashboard');

            //design

            // ********************** SERVICE ************************************
            Route::get("/services", function () {
                return view("admin.service.list");
            })->name('service');
            Route::get("/add/service", function () {
                return view("admin.service.add");
            })->name('add-service');
            Route::get("/get/service", [ServiceController::class, 'getService'])->name('get-services');
            Route::post("/save/service", [ServiceController::class, 'saveService'])->name('save-service');
            Route::get("/view/service", [ServiceController::class, 'viewService'])->name('view-service');
            Route::post("/update/service", [ServiceController::class, 'updateService'])->name('update-service');
            Route::get('/delete-service-image', [ServiceController::class, 'deleteserviceImage'])->name('delete-service-image');
            Route::get('/delete-service-link', [ServiceController::class, 'deleteServiceLink'])->name('delete-service-link');
            Route::get('/delete-tutorial-link', [ServiceController::class, 'deleteTutorialLink'])->name('delete-tutorial-link');
            Route::get('/delete-service', [ServiceController::class, 'deleteService'])->name('delete-service');
            Route::get('/edit-service/{slug}', [ServiceController::class, 'editService'])->name('edit-service');
            Route::get('/change-service-status', [ServiceController::class, 'changeserviceStatus'])->name('change-service-status');
            // ****************************** SERVICE END ****************************

            // ********************** BANNER ************************************
            Route::get("/banner", function () {
                return view("admin.banner.list");
            })->name('banner');
            Route::get("/add/banner", function () {
                return view("admin.banner.add");
            })->name('add-banner');
            Route::get("/get/banner", [BannerController::class, 'getBanner'])->name('get-banner');
            Route::post("/save/banner", [BannerController::class, 'savebanner'])->name('save-banner');
            Route::post("/update/banner", [BannerController::class, 'updatebanner'])->name('update-banner');
            Route::get('/delete-banner', [BannerController::class, 'deletebanner'])->name('delete-banner');
            Route::get('/edit-banner/{id}', [BannerController::class, 'editbanner'])->name('edit-banner');
            Route::get('/change-banner-status', [BannerController::class, 'changebannerStatus'])->name('change-banner-status');

            // ********************** BANNER END  ************************************

            // ********************** POST ************************************
            Route::get("/post", function () {
                return view("admin.post.list");
            })->name('post');
            Route::get("/add/post", function () {
                return view("admin.post.add");
            })->name('add-post');
            Route::get("/get/post", [BannerController::class, 'getpost'])->name('get-post');
            Route::post("/save/post", [BannerController::class, 'savepost'])->name('save-post');
            Route::post("/update/post", [BannerController::class, 'updatePost'])->name('update-post');
            Route::get('/delete-post', [BannerController::class, 'deletepost'])->name('delete-post');
            Route::get('/share/post/{id}', [BannerController::class, 'sharePost'])->name('share-post');
            Route::get('/edit-post/{id}', [BannerController::class, 'editpost'])->name('edit-post');
            // ********************** POST END  ************************************
            // ********************** offer ************************************
            Route::get("/offer", function () {
                //  echo "ddhi";die();
                return view("admin.offer.list");
            })->name('offer');
            Route::get("/add/offer", function () {
                return view("admin.offer.add");
            })->name('add-offer');
            Route::get("/get/offer", [BannerController::class, 'getoffer'])->name('get-offer');
            Route::post("/save/offer", [BannerController::class, 'saveoffer'])->name('save-offer');
            Route::get('/delete-offer', [BannerController::class, 'deleteoffer'])->name('delete-offer');

            Route::get('/change-offer-status', [BannerController::class, 'changeofferStatus'])->name('change-offer-status');
            // ********************** offer END  ************************************

            Route::get('/edit-agent/{slug}', [AgentController::class, 'editAgent'])->name('edit-agent');
            Route::get('/delete-agent', [AgentController::class, 'deleteAgent'])->name('delete-agent');
            Route::post('/save-agent', [AgentController::class, 'saveAgent'])->name('save-agent');
            Route::post('/update-agent', [AgentController::class, 'updateAgent'])->name('update-agent');
            Route::get('/agent', [AgentController::class, 'Agent'])->name('Agent');
            Route::get('/view-agent', [AgentController::class, 'viewAgent'])->name('view-agent');
            Route::get('/get-agent', [AgentController::class, 'getAgent'])->name('get-agent');
            Route::get('/change-agent-status', [AgentController::class, 'changeAgentStatus'])->name('change-agent-status');
            Route::get('/check-email-exist', [AgentController::class, 'checkMailExist'])->name('check-email-exist');
            Route::get('/check-number-exist', [AgentController::class, 'checkNumberExist'])->name('check-number-exist');
            Route::post('/import/agents', [AgentController::class, 'importAgent'])->name('import-agents');
            Route::get("/agents", function () {
                return view("admin.agent.list");
            })->name('agents');
               Route::get('/get-agent-with-hotlead', [AgentController::class, 'getAgentWithHotLeads'])->name('get-agent-with-hotlead');
            // ****************** enquiry **********************
            Route::get("/enquiry", function () {
                return view("admin.enquiry.list");
            })->name('enquiry');
            Route::get("/view-enquiry/{id}", [ServiceController::class, 'viewEnquiry'])->name('view-enquiry');
            Route::get("/edit-enquiry/{id}", [ServiceController::class, 'editEnquiry'])->name('edit-enquiry');
            Route::post("/update-enquiry", [ServiceController::class, 'updateEnquiry'])->name('update-enquiry');
            Route::get("/get/enquiry", [ServiceController::class, 'getEnquiry'])->name('get-enquiry');
            Route::get("/get/service/enquiry", [ServiceController::class, 'getServiceEnquiry'])->name('get-enquiry-of-service');
            Route::get("/get/agent/enquiry", [ServiceController::class, 'getAgentEnquiry'])->name('get-agent-enquiry');
            Route::get('/delete-enquiry', [ServiceController::class, 'deleteEnquiry'])->name('delete-enquiry');
            Route::get('/change-enquiry-status', [ServiceController::class, 'changeEnquiryStatus'])->name('change-enquiry-status');
            Route::post("/add/note", [ServiceController::class, 'addNote'])->name('add-note');
            Route::get("/delete/note", [ServiceController::class, 'deleteNote'])->name('delete-note');
            // ************************ end enquiry ***************
            Route::get("/agent-view", function () {
                return view("admin.agent.view");
            })->name('agent-view');
            Route::get("/add-agent", function () {
                return view("admin.agent.add");
            })->name('add-agent');

            // *********************** Notofication *******************

            Route::get('/push-notification', [NotificationController::class, 'index'])->name('push-notification');
            Route::post('/sendNotification', [NotificationController::class, 'sendNotification'])->name('send-notification');
            Route::post('/mark-as-read', [NotificationController::class, 'markNotification'])->name('markNotification');
            // Route::post('/save-token', [NotificationController::class, 'saveToken'])->name('save-token');
            // push notification


            Route::post('/save-token', [WebNotification::class, 'saveToken'])->name('save-token');
            // Route::match(['get', 'post'])('/send-notification', [WebNotification::class, 'sendNotification'])->name('send.notification');
            Route::match(['get', 'post'], '/send-notification', [WebNotification::class, 'sendNotification'])->name('send.notification');
            // *********************** End  Notofication *******************

            // *********************** Leads  *******************

            Route::get('/leads', [LeadsController::class, 'index'])->name('leads');
            Route::get('/export', [LeadsController::class, 'export'])->name('export');
            Route::post('/import', [LeadsController::class, 'import'])->name('import');
            Route::get('/get/leads', [LeadsController::class, 'getLeads'])->name('get-leads');
            Route::get('/delete/leads', [LeadsController::class, 'deleteLeads'])->name('delete-lead');
            Route::get('/change/lead/status', [LeadsController::class, 'changeLeadStatus'])->name('change-lead-status');
            // *********************** Leads  end *******************

            // *********************** hot  Leads  *******************
            Route::get("/assign/agents/for/hot/leads", function () {
                return view("admin.agent.assign-agents-for-hot-leads");
            })->name('assign-agents-for-hot-leads');
            Route::get('/agent-search', [HotLeadsController::class, 'search']);
            Route::get('/update-hot-leads', [HotLeadsController::class, 'updateHotLead'])->name('update.hot.leads');
            Route::get('/hot/leads', [HotLeadsController::class, 'index'])->name('hot-leads');
            Route::get('/hot/leads/export', [HotLeadsController::class, 'export'])->name('hot-leads-export');
            Route::post('/hot/leads/import', [HotLeadsController::class, 'import'])->name('hot-leads-import');
            Route::get('/get/hot/leads', [HotLeadsController::class, 'getLeads'])->name('get-hot-leads');
            Route::get('/delete/hot/leads', [HotLeadsController::class, 'deleteLeads'])->name('delete-hot-lead');
            Route::get('/change/hot/lead/status', [HotLeadsController::class, 'changeLeadStatus'])->name('change-hot-lead-status');
            // *********************** hot Leads  end *******************

            Route::get("/data/generation", function () {
                return view("admin.data-generation");
            })->name('data-generation');

            Route::get('/get/data/generation', [LeadsController::class, 'getDataGeration'])->name('get-data-generation');

            Route::get("/car/details", function () {
                return view("admin.car-detail");
            })->name('car-details');

            Route::get('/get/car/details', [LeadsController::class, 'getcardetails'])->name('get-car-details');

            Route::get('/delete/car/details', [LeadsController::class, 'deletecardetails'])->name('delete-car-details');

            // ********************** FAQ ************************************
            Route::get("/add/faq", function () {
                return view("admin.FAQ.add");
            })->name('add-faq');
            Route::get("/faq", function () {
                return view("admin.FAQ.list");
            })->name('faq');

            Route::post("/save/faq", [FAQController::class, 'saveFAQ'])->name('save-faq');
            Route::get("/get/faq", [FAQController::class, 'getFAQ'])->name('get-faq');
            Route::post("/update/faq", [FAQController::class, 'updateFAQ'])->name('update-faq');
            Route::get('/delete-faq', [FAQController::class, 'deleteFAQ'])->name('delete-faq');
            Route::get('/edit-faq/{id}', [FAQController::class, 'editFAQ'])->name('edit-faq');

            // ********************** FAQ END  ************************************

            // ********************** tutorialLink ************************************
            Route::get("/add/tutorialLink", function () {
                return view("admin.tutorialLink.add");
            })->name('add-tutorialLink');
            Route::get("/tutorialLink", function () {
                return view("admin.tutorialLink.list");
            })->name('tutorialLink');

            Route::post("/save/tutorialLink", [TutorialLinkController::class, 'saveTutorialLink'])->name('save-tutorialLink');
            Route::get("/get/tutorialLink", [TutorialLinkController::class, 'getTutorialLink'])->name('get-tutorialLink');
            Route::post("/update/tutorialLink", [TutorialLinkController::class, 'updateTutorialLink'])->name('update-tutorialLink');
            Route::get('/delete-tutorialLink', [TutorialLinkController::class, 'deleteTutorialLink'])->name('delete-tutorialLink');
            Route::get('/edit-tutorialLink/{id}', [TutorialLinkController::class, 'editTutorialLink'])->name('edit-tutorialLink');

            // ********************** tutorialLink END  ************************************

            Route::get("/loan/enquiries", function () {
                return view("admin.loan-enquiries");
            })->name('loan-enquiries');
            Route::get("/add-qrcode-image", function () {
                return view("admin.add-qrcode-image");
            })->name('add-qrcode-image');
            Route::post('/save-qrcode-image', [QRCodeController::class, 'saveqrcodeimage'])->name('save-qrcode-image');
            Route::get('/get/loans', [LoanController::class, 'getLoans'])->name('get-loans');
            Route::get('/change/loan/status', [LoanController::class, 'changeloanStatus'])->name('change-loan-status');

            Route::get('/download/qrcode', [QRCodeController::class, 'downloadQRCode'])->name('download.qrcode');
        });
    }
);
