<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\frontendAPI\LoginController;
use App\Http\Controllers\frontendAPI\ServiceController;
use App\Http\Controllers\frontendAPI\UserController;
use App\Http\Controllers\frontendAPI\LeadsController;
use App\Http\Controllers\frontendAPI\HotLeadsController;
use App\Http\Controllers\frontendAPI\NotificationController;
use App\Http\Controllers\frontendAPI\ForgotPasswordController;
use App\Http\Controllers\frontendAPI\DataGenerationController;
use App\Http\Controllers\API\ResetPasswordController;
use App\Http\Controllers\QRCodeController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

//Route::middleware('auth:sanctum')->group(function () {
Route::post('/login', [LoginController::class, 'login'])->name('login');
Route::get('/banner', [ServiceController::class, 'banner'])->name('banner');
Route::get('/offer', [ServiceController::class, 'offer'])->name('offer');
Route::post('/forgot-password', [ForgotPasswordController::class, 'sendPasswordToMail']);
Route::get('/fcm/send', [NotificationController::class, 'sendFcmTest'])->name('fcm-test');
Route::get('/faq', [LeadsController::class, 'faq'])->name('faq');
Route::get('/tutorialLink', [LeadsController::class, 'tutorialLink'])->name('tutorialLink');
Route::get('/all/services', [ServiceController::class, 'allServices'])->name('services');

Route::middleware(['auth:sanctum'])->group(function () {
    Route::post('/home', [LoginController::class, 'home'])->name('home');
    Route::get('/service/search', [ServiceController::class, 'serviceList'])->name('service-list');

    Route::post('/service-booking', [ServiceController::class, 'serviceBooking'])->name('service-booking');
    Route::get('/service-deatils', [ServiceController::class, 'serviceDetails'])->name('service-deatils');
    Route::post('/agent/dashboard', [UserController::class, 'dashboard'])->name('agent-dashboard');
    Route::get('/user-profile', [UserController::class, 'editAgent'])->name('edit-agent');
    Route::post('/update-profile', [UserController::class, 'updateAgent'])->name('update-agent');

    Route::get('/generate/offer/letter', [UserController::class, 'generateOfferLetter']);
    Route::get('/generate/id-card', [UserController::class, 'generateIDcard']);
    Route::get('/generate/visiting-card', [UserController::class, 'generateVistingcard']);

    Route::post('/logout', [LoginController::class, 'logout'])->name('logout');
    Route::post('/reset-password', [ForgotPasswordController::class, 'resetPassword']);

    // *************************** push notification section *****************************
    Route::get('/user/notifications', [NotificationController::class, 'listAll'])->name('list-all-notification');
    Route::get('/user/notifications/status', [NotificationController::class, 'unReadNotification'])->name('list-all-unread-notification');
    Route::delete('/user/notifications/delete', [NotificationController::class, 'deleteNotification'])->name('delete-notification');
    Route::post('/save/token', [NotificationController::class, 'saveToken'])->name('save-token');
    Route::get('/post', [UserController::class, 'post'])->name('post');
    // *************************** push notification section end *****************************

    // *********************** Leads  *******************

    Route::get('/leads', [LeadsController::class, 'leads'])->name('leads');
    Route::post('/assign/lead', [LeadsController::class, 'assignLeads'])->name('assign-leads');
    Route::get('/my/leads', [LeadsController::class, 'myLeads'])->name('my-leads');
    Route::post('/change/lead/status', [LeadsController::class, 'changeLeadStatus'])->name('change-lead-status');
    // *********************** Leads  end *******************

        // *********************** Hot Leads  *******************

    Route::get('/hot/leads', [HotLeadsController::class, 'leads'])->name('hot-leads');
    Route::post('/assign/hot/leads', [HotLeadsController::class, 'assignLeads'])->name('assign-hot-leads');
    Route::get('/my/hot/leadss', [HotLeadsController::class, 'myLeads'])->name('my-hot-leads');
    Route::post('/change/hot/leads/status', [HotLeadsController::class, 'changeLeadStatus'])->name('change-hot-lead-status');
    // ***********************Hot  Leads  end *******************


    // *********************** Data Generation  *******************

    Route::post('/add/data/generation', [DataGenerationController::class, 'add'])->name('add-data-generation');
     Route::post('/add/car/details', [DataGenerationController::class, 'addcardetails'])->name('add-car-details');
     
 Route::post('/add/gpay/account', [UserController::class, 'addgpay'])->name('add-gpay-account');
 Route::get('/gpay/account', [UserController::class, 'getgpay'])->name('gpay-account');
    // *********************** Data Generation end *******************

    Route::get('/generate/qrcode', [QRCodeController::class, 'generateQRCode'])->name('generate.qrcode');
    Route::get('/download/qrcode', [QRCodeController::class, 'downloadQRCode'])->name('download.qrcode');
    Route::get('/get/loan/enquiries', [QRCodeController::class, 'getLoanEnquiries'])->name('get-loan-enquiries');
    Route::post('/change/loan/enquiries/status', [QRCodeController::class, 'changeLoanEnquiriesStatus'])->name('change-loan-enquiries-status');
});