<html>

<head>
    <link rel="stylesheet" href="{{asset('assets/css/bootstrap.min.css')}}" media="all">
    <script src="{{asset('assets/js/jquery-3.2.1.min.js')}}"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.3.2/html2canvas.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.3.2/html2canvas.esm.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.3.2/html2canvas.js"></script>
    <style>
        :root {
            --color-one: #e6e6ff;
            --color-two: #1a1aff;
            --color-three: #b3b3ff;
        }

        body {
            font-family: 'Roboto', sans-serif;
            font-style: normal;
            font-weight: 300;

            font-size: 0.95em;
            color: #222;
        }

        .container {
            margin: 0;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }

        .card {
            border: 1px solid var(--color-three);
            margin-bottom: 20px;
            transition: border 0.1s, transform 0.3s;
        }


        .card .card-body h2 {
            color: var(--color-two);
        }

        .card img:hover {
            opacity: 0.6;
        }

        .card-p {
            color: #000;
        }

        .card-p i {
            color: var(--color-two);
            margin-right: 8px;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="row">
            <div class="col-md-6 offset-md-3">
                <div class="card" id="photo">
                    <img src="{{$data['image']}}" class="card-img-top" alt="...">

                    <div class="card-body card-p">
                        <div class="row">
                            <div class="col col-xs-6 ">

                                {{ucfirst($data['name'])}}
                            </div>
                            <div class="col col-xs-6" style="text-align:right;">
                                {{$data['mobile_number']}}
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div>
    </div>
    <script type=" text/javascript">
        jQuery(document).ready(function() {
            screenshot();
        });

        function screenshot() {
            html2canvas(document.getElementById("photo")).then(function(canvas) {
                downloadImage(canvas.toDataURL(), "backworker_post.png");
            });
        }

        function downloadImage(uri, filename) {
            var link = document.createElement('a');
            if (typeof link.download !== 'string') {
                window.open(uri);
            } else {
                link.href = uri;
                link.download = filename;
                accountForFirefox(clickLink, link);
            }
        }

        function clickLink(link) {
            link.click();
        }

        function accountForFirefox(click) {
            var link = arguments[1];
            document.body.appendChild(link);
            click(link);
            document.body.removeChild(link);
        }
    </script>
</body>


</html>