  @extends('admin.layout.dashboard-template')
  @section('content')
  <style>
      .pd-wrap {
          padding: 40px 0;
          font-family: 'Poppins', sans-serif;
      }

      .heading-section {
          text-align: center;
          margin-bottom: 20px;
      }

      .sub-heading {
          font-family: 'Poppins', sans-serif;
          font-size: 12px;
          display: block;
          font-weight: 600;
          color: #2e9ca1;
          text-transform: uppercase;
          letter-spacing: 2px;
      }

      .heading-section h2 {
          font-size: 32px;
          font-weight: 500;
          padding-top: 10px;
          padding-bottom: 15px;
          font-family: 'Poppins', sans-serif;
      }

      .user-img {
          width: 80px;
          height: 80px;
          border-radius: 50%;
          position: relative;
          min-width: 80px;
          background-size: 100%;
      }

      .carousel-testimonial .item {
          padding: 30px 10px;
      }

      .quote {
          position: absolute;
          top: -23px;
          color: #2e9da1;
          font-size: 27px;
      }

      .name {
          margin-bottom: 0;
          line-height: 14px;
          font-size: 17px;
          font-weight: 500;
      }

      .position {
          color: #adadad;
          font-size: 14px;
      }

      .owl-nav button {
          position: absolute;
          top: 50%;
          transform: translate(0, -50%);
          outline: none;
          height: 25px;
      }

      .owl-nav button svg {
          width: 25px;
          height: 25px;
      }

      .owl-nav button.owl-prev {
          left: 25px;
      }

      .owl-nav button.owl-next {
          right: 25px;
      }

      .owl-nav button span {
          font-size: 45px;
      }

      .product-thumb .item img {
          height: 100px;
      }

      .product-name {
          font-size: 22px;
          font-weight: 500;
          line-height: 22px;
          margin-bottom: 4px;
      }

      .product-price-discount {
          font-size: 22px;
          font-weight: 400;
          padding: 10px 0;
          clear: both;
      }

      .product-price-discount span.line-through {
          text-decoration: line-through;
          margin-left: 10px;
          font-size: 14px;
          vertical-align: middle;
          color: #a5a5a5;
      }

      .display-flex {
          display: flex;
      }

      .align-center {
          align-items: center;
      }

      .product-info {
          width: 100%;
      }

      .reviews-counter {
          font-size: 13px;
      }

      .reviews-counter span {
          vertical-align: -2px;
      }

      .rate {
          float: left;
          padding: 0 10px 0 0;
      }

      .rate:not(:checked)>input {
          position: absolute;
          top: -9999px;
      }

      .rate:not(:checked)>label {
          float: right;
          width: 15px;
          overflow: hidden;
          white-space: nowrap;
          cursor: pointer;
          font-size: 21px;
          color: #ccc;
          margin-bottom: 0;
          line-height: 21px;
      }

      .rate:not(:checked)>label:before {
          content: '\2605';
      }

      .rate>input:checked~label {
          color: #ffc700;
      }

      .rate:not(:checked)>label:hover,
      .rate:not(:checked)>label:hover~label {
          color: #deb217;
      }

      .rate>input:checked+label:hover,
      .rate>input:checked+label:hover~label,
      .rate>input:checked~label:hover,
      .rate>input:checked~label:hover~label,
      .rate>label:hover~input:checked~label {
          color: #c59b08;
      }

      .product-dtl p {
          font-size: 14px;
          line-height: 24px;
          color: #7a7a7a;
      }

      .product-dtl .form-control {
          font-size: 15px;
      }

      .product-dtl label {
          line-height: 16px;
          font-size: 15px;
      }

      .form-control:focus {
          outline: none;
          box-shadow: none;
      }

      .product-count {
          margin-top: 15px;
      }

      .product-count .qtyminus,
      .product-count .qtyplus {
          width: 34px;
          height: 34px;
          background: #212529;
          text-align: center;
          font-size: 19px;
          line-height: 36px;
          color: #fff;
          cursor: pointer;
      }

      .product-count .qtyminus {
          border-radius: 3px 0 0 3px;
      }

      .product-count .qtyplus {
          border-radius: 0 3px 3px 0;
      }

      .product-count .qty {
          width: 60px;
          text-align: center;
      }

      .round-black-btn {
          border-radius: 4px;
          background: #212529;
          color: #fff;
          padding: 7px 45px;
          display: inline-block;
          margin-top: 20px;
          border: solid 2px #212529;
          transition: all 0.5s ease-in-out 0s;
      }

      .round-black-btn:hover,
      .round-black-btn:focus {
          background: transparent;
          color: #212529;
          text-decoration: none;
      }

      .product-info-tabs {
          margin-top: 25px;
      }

      .product-info-tabs .nav-tabs {
          border-bottom: 2px solid #d8d8d8;
      }

      .product-info-tabs .nav-tabs .nav-item {
          margin-bottom: 0;
      }

      .product-info-tabs .nav-tabs .nav-link {
          border: none;
          border-bottom: 2px solid transparent;
          color: #323232;
      }

      .product-info-tabs .nav-tabs .nav-item .nav-link:hover {
          border: none;
      }

      .product-info-tabs .nav-tabs .nav-item.show .nav-link,
      .product-info-tabs .nav-tabs .nav-link.active,
      .product-info-tabs .nav-tabs .nav-link.active:hover {
          border: none;
          border-bottom: 2px solid #d8d8d8;
          font-weight: bold;
      }

      .product-info-tabs .tab-content .tab-pane {
          padding: 30px 20px;
          font-size: 15px;
          line-height: 24px;
          color: #7a7a7a;
      }

      .review-form .form-group {
          clear: both;
      }

      .mb-20 {
          margin-bottom: 20px;
      }

      .review-form .rate {
          float: none;
          display: inline-block;
      }

      .review-heading {
          font-size: 24px;
          font-weight: 600;
          line-height: 24px;
          margin-bottom: 6px;
          text-transform: uppercase;
          color: #000;
      }

      .review-form .form-control {
          font-size: 14px;
      }

      .review-form input.form-control {
          height: 40px;
      }

      .review-form textarea.form-control {
          resize: none;
      }

      .review-form .round-black-btn {
          text-transform: uppercase;
          cursor: pointer;
      }

      .subtitle {
          color: #b5a56e;
          font-size: 17px;
          font-family: 'Poppins', sans-serif !important;

      }

      .gray {
          color: #666;
      }

      .red {
          color: #f56960;
      }
  </style>
  <div class="db-info-wrap db-add-tour-wrap">
      <div class="row">
          <div class="container dashboard-box">
              <div class="heading-section">
                  <h2>{{$data->title}}</h2>

              </div>
              <div class=" row">
                  <div class="col-md-7">
                      <div class="item">
                          <img src="{{asset('uploads/services/'.$data->image)}}">
                      </div>
                  </div>
                  <div class="col-md-5">
                      <div class="product-dtl">
                          <div class="row">
                              <div class="col-md-6">
                                  <h5><span class="gray">Commission Amount</h5>
                              </div>
                              <div class="col-md-1">
                                  <p>: </p>
                              </div>
                              <div class="col-md-5">
                                  <h4 class="red">{{$data->commission}}
                                  </h4>
                              </div>
                          </div>
                          <div class="row">
                              <div class="col-md-6">
                                  <h5><span class="gray">Product Code</h5>
                              </div>
                              <div class="col-md-1">
                                  <p>: </p>
                              </div>
                              <div class="col-md-5">
                                  <h4 class="red">{{$data->code}}
                                  </h4>
                              </div>
                          </div>
                          <div class="row">
                              <div class="col-md-6">
                                  <h5><span class="gray">Application Through</h5>
                              </div>
                              <div class="col-md-1">
                                  <p>: </p>
                              </div>
                              <div class="col-md-5">
                                  <h4 class="red">{{$data->apply_service_through}}
                                  </h4>
                                  @if($data->apply_service_through=='Link')
                                  @foreach($data->links as $item)
                                  <a href="{{$item->link}}" target="_blank"><u>Go to Lead Link</u>&nbsp; <i class="fas fa-thumbs-up"></i></a>
                                  @endforeach
                                  @endif
                              </div>
                          </div>
                          <hr>
                          @php
                          $tl=count($data->tutorialLinks->toArray());

                          @endphp
                          @if($tl>0)
                          <h3>Tutorial Links</h3>
                          <div class="font-weight-bold text-dark " style="font-family: Poppins, sans-serif; color: rgb(59, 68, 79); font-size: 16px; font-weight: 500 !important;"><br></div>

                          @foreach($data->tutorialLinks as $item)
                          <div class="flex-horizontal-center mb-3 text-gray-1" style="font-family: Poppins, sans-serif; display: flex; align-items: center; font-size: 16px; color: rgb(103, 116, 124) !important;"><span class="fa fa-angle-right mr-3 font-size-16 text-primary" style="font-size: 1rem; color: rgb(41, 124, 187) !important;"></span><a href="{{$item->link}}">{{$item->link}}</a></div>
                          @endforeach

                          @endif
                      </div>

                  </div>
              </div>
              <div class="product-info-tabs">
                  <ul class="nav nav-tabs" id="myTab" role="tablist">
                      <li class="nav-item">
                          <a class="nav-link active" id="description-tab" data-toggle="tab" href="#description" role="tab" aria-controls="description" aria-selected="true">Description</a>
                      </li>
                      <li class="nav-item">
                          <a class="nav-link" id="description-tab" data-toggle="tab" href="#applicatons" role="tab" aria-controls="description" aria-selected="true">Applications </a>
                      </li>
                  </ul>
                  <div class="tab-content" id="myTabContent">
                      <div class="tab-pane fade show active" id="description" role="tabpanel" aria-labelledby="description-tab">
                          {!! $data->description !!}
                      </div>
                      <div class="tab-pane fade" id="applicatons" role="tabpanel" aria-labelledby="description-tab">
                          <table class="table booking dataTable no-footer" id="booking" role="grid" aria-describedby="DataTables_Table_0_info" style="width: 953px;">
                              <thead>
                                  <tr role="row">
                                      <th class="sorting_asc" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Sl.No: activate to sort column descending" style="width: 77px;">Sl.No</th>
                                      <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1" colspan="1" aria-label="USER: activate to sort column ascending" style="width: 71px;">Customer Name</th>
                                      <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1" colspan="1" aria-label="PACKAGE: activate to sort column ascending" style="width: 205px;">Phone Number</th>
                                      <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1" colspan="1" aria-label="NO:DAYS: activate to sort column ascending" style="width: 103px;">Service</th>
                                      <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1" colspan="1" aria-label="NO:DAYS: activate to sort column ascending" style="width: 103px;">Agent</th>
                                      <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1" colspan="1" aria-label="Status: activate to sort column ascending" style="width: 127px;">Status</th>
                                      <th class="sorting_disabled" rowspan="1" colspan="1" aria-label="Action" style="width: 94px;">Action</th>
                                  </tr>
                              </thead>
                              <tbody>

                              </tbody>
                          </table>
                      </div>
                  </div>
              </div>
          </div>
      </div>
  </div>
  <script type="text/javascript">
      $(function() {
          var table = $('.table').DataTable({
              processing: true,
              serverSide: true,
              ajax: ({
                  url: "{{ route('admin.get-enquiry-of-service') }}",
                  method: "GET",
                  data: {
                      'id': "<?php echo $data->id; ?>"
                  },
              }),
              columns: [{
                      data: 'DT_RowIndex',
                      name: 'DT_RowIndex'
                  },
                  {
                      data: 'customer_name',
                      name: 'customer_name'
                  },
                  {
                      data: 'phone_number',
                      name: 'phone_number'
                  },
                  {
                      data: 'service',
                      name: 'service'
                  },
                  {
                      data: 'agent',
                      name: 'agent'
                  },
                  {
                      data: 'status',
                      name: 'status'
                  },
                  {
                      data: 'action',
                      name: 'action',
                      orderable: false,
                      searchable: false
                  },
              ],
              "select": {
                  'style': 'multi',
                  'selector': 'td:first-child' //only checkbox can select row
              },
          });

      });

      $(document).on('click', '#getBookingDeleteID', function(e) {
          var answer = confirm("Are you sure you want to delete from this item?");
          if (answer) {
              id = $(this).data('id');
              e.preventDefault();
              $.ajaxSetup({
                  headers: {
                      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                  }
              });
              $.ajax({
                  url: "{{ route('admin.delete-enquiry') }}",
                  method: "GET",
                  data: {
                      'id': id
                  },
                  success: function(result) {
                      $('.table').DataTable().ajax.reload();
                      if (result == 1) {
                          $(".alert-success").text("Service Deleted successfully.");
                      } else {
                          $(".alert-danger").text("Something went wrong.");
                      }

                  }
              });
          }
      });
  </script>
  @endsection