  @extends('admin.layout.dashboard-template')
  @section('content')
  <div class="db-info-wrap db-add-tour-wrap">
      <div class="row">
          <!-- Listings -->
          <div class="col-lg-12 col-xl-12">
              @if(\Session::get('success'))
              <div class="alert alert-success alert-dismissible fade show" role="alert">
                  <div class="alert-body">
                      {{ \Session::get('success') }}
                  </div>
                  <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
              </div>
              @endif
              {{ \Session::forget('success') }}
              @if(\Session::get('error'))
              <div class="alert alert-danger alert-dismissible fade show" role="alert">
                  <div class="alert-body">
                      {{ \Session::get('error') }}
                  </div>
                  <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
              </div>
              @endif
              <div class="dashboard-box">
                  <h4>Send Notification</h4>
                  <div class="card">
                      <div class="card-header">{{ __('Dashboard') }}</div>

                      <div class="card-body">
                          @if (session('success'))
                          <div class="alert alert-success" role="alert">
                              {{ session('success') }}
                          </div>
                          @endif

                          <form action="{{ route('admin.send-notification') }}" method="POST" enctype="multipart/form-data">
                              @csrf
                              <div class="form-group">
                                  <label>Title</label>
                                  <input type="text" class="form-control" name="title">
                              </div>
                              <div class="form-group">
                                  <label>Body</label>
                                  <textarea class="form-control" name="body"></textarea>
                              </div>
                              <div class="form-group">
                                  <label>Image<span style:"color:#eee;"> (Optinal)</span></label>
                                  <input type="file" class="form-control" name="image">
                              </div>
                              <button type="submit" id="#allow_not_btn" class=" btn btn-primary">Send Notification</button>
                          </form>

                      </div>
                  </div>
              </div>

          </div>
      </div>
  </div>


  @endsection