  @extends('admin.layout.dashboard-template')
  @section('content')
  <div class="db-info-wrap db-package-wrap">
      <div class="dashboard-box table-opp-color-box">
          <h4>offer</h4>
          <div class="text-right">
              <a href="{{route('admin.add-offer')}}" class="btn btn-success mtb">ADD offer</a>
          </div>
          @if(\Session::get('success'))
          <div class="alert alert-success alert-dismissible fade show" role="alert">
              <div class="alert-body">
                  {{ \Session::get('success') }}
              </div>
              <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
          </div>
          @endif
          {{ \Session::forget('success') }}
          @if(\Session::get('error'))
          <div class="alert alert-danger alert-dismissible fade show" role="alert">
              <div class="alert-body">
                  {{ \Session::get('error') }}
              </div>
              <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
          </div>
          @endif
          <div class="table-responsive">
              <table class="table">
                  <thead>
                      <tr>
                          <th>Sl.No</th>
                          <th>Image</th>
                                 <th>Expiry Date</th>
                           <th>Status</th>
                          <th>Action</th>
                      </tr>
                  </thead>
                  <tbody>

                  </tbody>
              </table>
          </div>
      </div>

  </div>
  <script type="text/javascript">
      $(function() {
          var table = $('.table').DataTable({
              processing: true,
              serverSide: true,
              ajax: "{{ route('admin.get-offer') }}",
              columns: [{
                      data: 'DT_RowIndex',
                      name: 'DT_RowIndex'
                  },
                  {
                      data: 'offer',
                      name: 'offer'
                  },
                   {
                      data: 'expiry_date',
                      name: 'expiry_date'
                  },
                {
                      data: 'status',
                      name: 'status'
                  },
                  {
                      data: 'action',
                      name: 'action',
                      orderable: false,
                      searchable: false
                  },
              ],
              "select": {
                  'style': 'multi',
                  'selector': 'td:first-child' //only checkbox can select row
              },
          });

      });

      $(document).on('click', '#getDeleteId', function(e) {
          var answer = confirm("Are you sure you want to delete from this item?");
          if (answer) {
              id = $(this).data('id');
              e.preventDefault();
              $.ajaxSetup({
                  headers: {
                      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                  }
              });
              $.ajax({
                  url: "{{ route('admin.delete-offer') }}",
                  method: "GET",
                  data: {
                      'id': id
                  },
                  success: function(result) {
                      $('.table').DataTable().ajax.reload();
                      if (result == 1) {
                          $(".alert-success").text("Service Deleted successfully.");
                      } else {
                          $(".alert-danger").text("Something went wrong.");
                      }

                      $('.data-table').DataTable().ajax.reload();

                  }
              });
          }
      });
      
       $(document).on('click', '#status', function(e) {
          id = $(this).data('id');
          status = $(this).data('value');
          e.preventDefault();
          $.ajaxSetup({
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              }
          });
          $.ajax({
              url: "{{ route('admin.change-offer-status') }}",
              method: "GET",
              data: {
                  'id': id,
                  'status': status
              },
              success: function(result) {
                  $('.table').DataTable().ajax.reload();
                  if (result == 1) {
                      $(".alert-success").text("Status Changed successfully.");
                  } else {
                      $(".alert-danger").text("Something went wrong.");
                  }

                  $('.data-table').DataTable().ajax.reload();

              }
          });
      });
  </script>
  @endsection