  @extends('admin.layout.dashboard-template')
  @section('content')
  <style>
      .filepond--root {
          width: 500px
      }

      .filepond--drop-label {
          color: #4c4e53;
      }

      .filepond--label-action {
          text-decoration-color: #babdc0;
          margin-top: 10px;

      }

      .filepond--panel-root {
          border-radius: 2em;
          background-color: #fff;
          height: 1em;
      }

      .service_records,
      .remove {
          margin-bottom: 15px;
      }

      .service_records input,
      .remove input {
          margin-right: 15px;
      }



      .upload__box {
          padding: 40px;

      }

      .upload__inputfile {
          width: 0.1px;
          height: 0.1px;
          opacity: 0;
          overflow: hidden;
          position: absolute;
          z-index: -1;

      }

      .upload__btn {
          display: inline-block;
          font-weight: 600;
          color: #fff;
          text-align: center;
          min-width: 116px;
          padding: 12px;
          transition: all 0.3s ease;
          cursor: pointer;
          border: 2px solid;
          background-color: #F56960;
          border-radius: 10px;
          text-transform: uppercase;
          line-height: 26px;
          font-size: 14px;
      }

      .upload__btn:hover {

          background-color: unset;
          color: #4045ba;
          transition: all 0.3s ease;

      }

      .upload__btn-box {
          margin-bottom: 10px;
      }


      .upload__img-wrap {
          display: flex;
          flex-wrap: wrap;
          margin: 0 -10px;
      }


      .upload__img-box {
          width: 200px;
          padding: 0 10px;
          margin-bottom: 12px;
      }

      .upload__img-close {
          width: 24px;
          height: 24px;
          border-radius: 50%;
          background-color: rgba(0, 0, 0, 0.5);
          position: absolute;

          top: 10px;
          right: 10px;
          text-align: center;
          line-height: 24px;
          z-index: 1;
          cursor: pointer;
      }

      .upload__img-close:after {
          content: "✖";
          font-size: 14px;
          color: white;
      }

      .img-bg {
          background-repeat: no-repeat;
          background-position: center;
          background-size: cover;
          position: relative;
          padding-bottom: 100%;
      }
  </style>
  <div class="db-info-wrap db-add-tour-wrap">
      <div class="row">

          <form action="{{route('admin.save-banner')}}" method="post" enctype="multipart/form-data" class="col-12">
              @csrf
              <!-- Listings -->
              <div class="col-lg-12 col-xl-12">
                  @if(\Session::get('success'))
                  <div class="alert alert-success alert-dismissible fade show" role="alert">
                      <div class="alert-body">
                          {{ \Session::get('success') }}
                      </div>
                      <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
                  </div>
                  @endif
                  {{ \Session::forget('success') }}
                  @if(\Session::get('error'))
                  <div class="alert alert-danger alert-dismissible fade show" role="alert">
                      <div class="alert-body">
                          {{ \Session::get('error') }}
                      </div>
                      <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
                  </div>
                  @endif
                  <div class="dashboard-box">
                      <h4><span style="color:red">* </span>Service Details</h4>
                      <div class="custom-field-wrap">
                          <div class="row">
                              <div class="col-12">
                                  <div class="form-group">
                                      <label>Select Service</label>
                                      <select name="service">
                                          @foreach(App\Models\Service::get() as $item)
                                          <option value="{{$item->id}}">{{$item->title}}</option>
                                          @endforeach
                                      </select>
                                  </div>
                              </div>

                          </div>


                      </div>
                  </div>

                  <div class="dashboard-box">
                      <h4><span style="color:red">* </span>Upload Banner</h4>
                      <div class="custom-field-wrap">
                          <div class="dragable-field">
                              <div class="dragable-field-inner">
                                  <div class="upload-input">
                                      <div class="form-group">
                                          <div class="upload__box">
                                              <div class="upload__btn-box">
                                                  <label class="upload__btn">
                                                      Upload Image
                                                      <input type="file" name="image" required class="upload__inputfile">
                                                  </label>
                                              </div>
                                              <div class="upload__img-wrap"></div>
                                          </div>


                                      </div>
                                  </div>
                              </div>
                          </div>

                      </div>
                  </div>

                  <div class="col-12 text-center">
                      <button type="submit" id="add" class="btn btn-primary">Add Banner</button>
                  </div>
              </div>
          </form>
      </div>
  </div>
  <script>
      jQuery(document).ready(function() {
          ImgUpload();
      });

      function ImgUpload() {
          var imgWrap = "";
          var imgArray = [];

          $('.upload__inputfile').each(function() {
              $(this).on('change', function(e) {
                  imgWrap = $(this).closest('.upload__box').find('.upload__img-wrap');
                  var maxLength = $(this).attr('data-max_length');

                  var files = e.target.files;
                  var filesArr = Array.prototype.slice.call(files);
                  var iterator = 0;
                  filesArr.forEach(function(f, index) {

                      if (!f.type.match('image.*')) {
                          return;
                      }

                      if (imgArray.length > maxLength) {
                          return false
                      } else {
                          var len = 0;
                          for (var i = 0; i < imgArray.length; i++) {
                              if (imgArray[i] !== undefined) {
                                  len++;
                              }
                          }
                          if (len > maxLength) {
                              return false;
                          } else {
                              imgArray.push(f);

                              var reader = new FileReader();
                              reader.onload = function(e) {
                                  var html = "<div class='upload__img-box'><div style='background-image: url(" + e.target.result + ")' data-number='" + $(".upload__img-close").length + "' data-file='" + f.name + "' class='img-bg'><div class='upload__img-close'></div></div></div>";
                                  imgWrap.html(html);
                                  iterator++;
                              }
                              reader.readAsDataURL(f);
                          }
                      }
                  });
              });
          });

          $('body').on('click', ".upload__img-close", function(e) {
              var file = $(this).parent().data("file");
              for (var i = 0; i < imgArray.length; i++) {
                  if (imgArray[i].name === file) {
                      imgArray.splice(i, 1);
                      break;
                  }
              }
              $(this).parent().parent().remove();
          });
      }



      $('.extra-fields-service').click(function() {
          $('.service_records').clone().appendTo('.service_records_dynamic');
          $('.service_records_dynamic .service_records').addClass('single remove');
          $('.single .extra-fields-service').remove();
          $('.single').append('<a href="javascript:void(0)" class="remove-field btn-remove-service">Remove Field</a>');
          $('.service_records_dynamic > .single').attr("class", "remove");

          $('.service_records_dynamic input').each(function() {
              var count = 0;
              var fieldname = $(this).attr("name");
              $(this).attr('name', fieldname + count);
              count++;
          });

      });

      $(document).on('click', '.remove-field', function(e) {
          $(this).parent('.remove').remove();
          e.preventDefault();
      });
  </script>

  @endsection