  @extends('admin.layout.dashboard-template')
  @section('content')

  <div class="db-info-wrap db-package-wrap">
      <div class="dashboard-box table-opp-color-box">
          <h4>Eligible Agents for Hot Leads</h4>


          <div class="card mb-5">
              <div class=" card-body">
                  <h4>Add Bulk Agents</h4>
                  <form method="GET" action="{{ route('admin.update.hot.leads') }}">
                      @csrf
                      <input type="hidden" name="agent_id" id="agent_id">
                     <input type="hidden" name="status" value="1">
                      <input type="text" id="agent-search" class="form-control" placeholder="Search by name or mobile">
                      <ul id="agent-suggestions" class="list-group"></ul>

                      <button type="submit" class="btn btn-primary mt-2">Mark as Hot Lead Agent</button>
                  </form>
              </div>
          </div>

          @if(\Session::get('success'))
          <div class="alert alert-success alert-dismissible fade show" role="alert">
              <div class="alert-body">
                  {{ \Session::get('success') }}
              </div>
              <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
          </div>
          @endif
          {{ \Session::forget('success') }}
          @if(\Session::get('error'))
          <div class="alert alert-danger alert-dismissible fade show" role="alert">
              <div class="alert-body">
                  {{ \Session::get('error') }}
              </div>
              <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">x</button>
          </div>
          @endif
          <div class="table-responsive">
              <table class="table text-center">
                  <thead>
                      <tr>
                          <th>Sl<br>No</th>
                          <th>ID</th>
                          <th>Name</th>
                          <th>Mobile<br> Number</th>
                          <th>Email</th>
                          <th>Total <br>commission</th>
                          <th>Status</th>
                          <th>Action</th>
                      </tr>
                  </thead>
                  <tbody>
                      <!-- <tr role="row" class="odd">
                          <td class="sorting_1">1</td>
                          <td><span class="package-name">manu mathew</span></td>
                          <td>9188360233</td>
                          <td>manu@gmail.com</td>
                          <td><span class="badge badge-primary">350</span></td>
                          <td><a href="javascript:void(0)" data-id="26" data-value="0" id="status"><span class="badge badge-danger">Inactive</span></a></td>
                          <td> <a href="{{route('admin.agent-view')}}" class="text-muted"> <span class="badge badge-success"><i class="far fa-eye"></i></span></a>
                              <a href="javascript:void(0);" class="text-muted"> <span class="badge badge-success"><i class="far fa-edit"></i></span></a>
                              <a href="javascript:void(0);" data-id="26" id="getDeleteId" class="text-muted"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>
                          </td>
                      </tr> -->

                  </tbody>
              </table>
          </div>
      </div>
      <!-- Modal -->
     
  </div>
  </div>
  <script type="text/javascript">
      $(function() {

          var table = $('.table').DataTable({
              processing: true,
              serverSide: true,
           //   ajax: "{{ route('admin.get-agent') }}",
                 ajax: {
                  url: "{{ route('admin.get-agent-with-hotlead') }}",
                  method: 'GET',
                  data: function(d) {
                      d.hot_leads = 1;
                  }
              },

              columns: [{
                      data: 'DT_RowIndex',
                      name: 'DT_RowIndex'
                  },
                  {
                      data: 'id',
                      name: 'id'
                  },
                  {
                      data: 'name',
                      name: 'name'
                  },
                  {
                      data: 'number',
                      name: 'number'
                  },
                  {
                      data: 'email',
                      name: 'email'
                  },

                  {
                      data: 'commission',
                      name: 'commission'
                  },
                  {
                      data: 'status',
                      name: 'status'
                  },
                  {
                      data: 'action',
                      name: 'action',
                      orderable: false,
                      searchable: false
                  },
              ],
              "select": {
                  'style': 'multi',
                  'selector': 'td:first-child' //only checkbox can select row
              },
          });

      });
      $(document).on('click', '#status', function(e) {
          id = $(this).data('id');
          status = $(this).data('value');
          e.preventDefault();
          $.ajaxSetup({
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              }
          });
          $.ajax({
              url: "{{ route('admin.change-agent-status') }}",
              method: "GET",
              data: {
                  'id': id,
                  'status': status
              },
              success: function(result) {
                  $('.table').DataTable().ajax.reload();
                  if (result == 1) {
                      $(".alert-success").text("Status Changed successfully.");
                  } else {
                      $(".alert-danger").text("Something went wrong.");
                  }

                  $('.data-table').DataTable().ajax.reload();

              }
          });
      });


     


      $('#agent-search').on('input', function() {
          const query = $(this).val();
          if (query.length >= 2) {
              $.get('/agent-search', {
                  query: query
              }, function(data) {
                  $('#agent-suggestions').empty();
                  data.forEach(function(agent) {
                      $('#agent-suggestions').append(`<li class="list-group-item" data-id="${agent.id}">${agent.name} (${agent.mobile_number})</li>`);
                  });
              });
          } else {
              $('#agent-suggestions').empty();
          }
      });

      $(document).on('click', '#agent-suggestions li', function() {
       // alert($(this).data('id'));
          $('#agent_id').val($(this).data('id'));
          $('#agent-search').val($(this).text());
          $('#agent-suggestions').empty();
      });
  </script>



  @endsection