@extends('admin.layout.template')
@section('content')

<body>
    <div class="login-page" style="background-image: url('{{asset('assets/images/bg.jpg')}}');">
        <div class="login-from-wrap">
            @if(\Session::get('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <div class="alert-body">
                    {{ \Session::get('success') }}
                </div>
                <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
            </div>
            @endif
            {{ \Session::forget('success') }}
            @if(\Session::get('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <div class="alert-body">
                    {{ \Session::get('error') }}
                </div>
                <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
            </div>
            @endif
            
            <form class="login-from" action="{{route('save.enquiries')}}" method="post">
                @csrf
            
                <h3 class="text-center">Enquiry Form</h3>
                <div class="form-group">
                    <label for="first_name1">Name</label>
                    <input type="text" class="validate" id="name" name="name" value="{{old('name') }}" autofocus />
                    @if ($errors->has('name'))
                    <span class="help-block font-red-mint">
                        <strong>{{ $errors->first('name') }}</strong>
                    </span>
                    @endif
                </div>
                <div class="form-group">
                    <label for="last_name">Mobile Number</label>
                    <input type="hidden" name="employee_id" value="{{$employee_id}}">
                    <input type="text" min="10" class="validate" id="phone" name="phone">
                    @if ($errors->has('phone'))
                    <span class="help-block font-red-mint">
                        <strong>{{ $errors->first('phone') }}</strong>
                    </span>
                    @endif
                </div>
                <div class="form-group">
                    <label for="first_name1">District</label>
                    <input type="text" class="validate" id="district" name="district" value="{{old('district') }}" autofocus />
                    @if ($errors->has('district'))
                    <span class="help-block font-red-mint">
                        <strong>{{ $errors->first('district') }}</strong>
                    </span>
                    @endif
                </div>
                <div class="form-group">
                    <label for="last_name">Product</label>
                    <select class="validate" id="service" name="service">
                        <option value="">Select Service</option>
                        <option value="Personal Loan">Personal Loan</option>
                        <option value="Car Loan">Car Loan</option>
                        <option value="Car Loan Top Up">Car Loan Top Up</option>
                        <option value="Credit Card">Credit Card</option>
                    </select>
                    @if ($errors->has('service'))
                    <span class="help-block font-red-mint">
                        <strong>{{ $errors->first('service') }}</strong>
                    </span>
                    @endif
                </div>

               
                <div class="form-group">
                    <button type="submit" class="btn btn-dark ">SUBMIT</button>
                </div>
               
            </form>
        </div>
    </div>

    @endsection