  @extends('admin.layout.dashboard-template')
  @section('content')
  <div class="db-info-wrap db-service-wrap">
      <div class="dashboard-box table-opp-color-box">

          @if(\Session::get('success'))
          <div class="alert alert-success alert-dismissible fade show" role="alert">
              <div class="alert-body">
                  {{ \Session::get('success') }}
              </div>
              <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
          </div>
          @endif
          {{ \Session::forget('success') }}
          @if(\Session::get('error'))
          <div class="alert alert-danger alert-dismissible fade show" role="alert">
              <div class="alert-body">
                  {{ \Session::get('error') }}
              </div>
              <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
          </div>
          @endif
         

          <div class="table-responsive">
              <br><br>
              <h4>Qrcode Enquires</h4>
              <div class="text-right">
              <a href="{{route('admin.add-qrcode-image')}}" class="btn btn-success mtb">ADD QR-code Template image</a>
          </div>
              <table class="table">
                  <thead>
                      <tr>
                          <th style="width:10% !important;">Sl.No</th>
                          <th>NAME</th>
                          <th>Mobile</th>
                          <th>District</th>
                          <th>service</th>
                          <th>STATUS</th>
                          <th>STATUS</th>
                          <th>employee</th>
                          <th>Applied date</th>
                      </tr>
                  </thead>
                  <tbody>

                  </tbody>
              </table>
          </div>
      </div>

  </div>
  <script type="text/javascript">
      $(function() {

          var table = $('.table').DataTable({
              processing: true,
              serverSide: true,
              ajax: "{{ route('admin.get-loans') }}",
              columns: [{
                      data: 'DT_RowIndex',
                      name: 'DT_RowIndex'
                  },
                  {
                      data: 'customer_name',
                      name: 'customer_name'
                  },
                  {
                      data: 'mobile',
                      name: 'mobile'
                  },
                  {
                      data: 'district',
                      name: 'district'
                  },
                  {
                      data: 'service',
                      name: 'service'
                  },
                  
                  {
                      data: 'status',
                      name: 'status'
                  },
                  {
                      data: 'export_status',
                      name: 'export_status',
                        visible: false
                  },
                  {
                      data: 'employee',
                      name: 'employee'
                  },
                  {
                      data: 'date',
                      name: 'date'
                  },
                 
              ],
              "select": {
                  'style': 'multi',
                  'selector': 'td:first-child' //only checkbox can select row
              },
              dom: 'Bfrtip',
              buttons: [{
                      extend: 'csv',
                      exportOptions: {
                          columns: [0, 1, 2, 3, 4, 5, 7,8,9]
                      }
                  },
                  {
                      extend: 'copy',
                      exportOptions: {
                          columns: [0, 1, 2, 3, 4, 5, 7,8,9]
                      }
                  },
                  {
                      extend: 'excel',
                      exportOptions: {
                          columns: [0, 1, 2, 3, 4, 5, 7,8,9]
                      }
                  },
                  {
                      extend: 'pdf',
                      exportOptions: {
                          columns: [0, 1, 2, 3, 4, 5, 7,8,9]
                      }
                  },
                  {
                      extend: 'print',
                      exportOptions: {
                          columns: [0, 1, 2, 3, 4, 5, 7,8,9]
                      }
                  },

              ]
          });

      });

      $(document).on('click', '#getDeleteId', function(e) {
          var answer = confirm("Are you sure you want to delete from this item?");
          if (answer) {
              id = $(this).data('id');
              e.preventDefault();
              $.ajaxSetup({
                  headers: {
                      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                  }
              });
              $.ajax({
                  url: "{{ route('admin.delete-lead') }}",
                  method: "GET",
                  data: {
                      'id': id
                  },
                  success: function(result) {
                      $('.table').DataTable().ajax.reload();
                      if (result == 1) {
                          $(".alert-success").text("Lead Deleted successfully.");
                      } else {
                          $(".alert-danger").text("Something went wrong.");
                      }

                      $('.data-table').DataTable().ajax.reload();

                  }
              });
          }
      });

      $(document).on('click', '#leadStatus', function(e) {
          id = $(this).data('id');
          status = $(this).data('value');
          e.preventDefault();
          $.ajaxSetup({
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              }
          });
          $.ajax({
              url: "{{ route('admin.change-loan-status') }}",
              method: "GET",
              data: {
                  'id': id,
                  'status': status
              },
              success: function(result) {
                  $('.table').DataTable().ajax.reload();
                  if (result == 1) {
                      $(".alert-success").text("Status Changed successfully.");
                  } else {
                      $(".alert-danger").text("Something went wrong.");
                  }

                  $('.data-table').DataTable().ajax.reload();

              }
          });
      });
  </script>
  @endsection