  @extends('admin.layout.dashboard-template')
  @section('content')
  <div class="db-info-wrap db-service-wrap">
      <div class="dashboard-box table-opp-color-box">

          @if(\Session::get('success'))
          <div class="alert alert-success alert-dismissible fade show" role="alert">
              <div class="alert-body">
                  {{ \Session::get('success') }}
              </div>
              <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
          </div>
          @endif
          {{ \Session::forget('success') }}
          @if(\Session::get('error'))
          <div class="alert alert-danger alert-dismissible fade show" role="alert">
              <div class="alert-body">
                  {{ \Session::get('error') }}
              </div>
              <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
          </div>
          @endif
          <div class="card mb-5">
              <div class=" card-body">
                  <h4>Add Leads</h4>
                  <form action="{{ route('admin.import') }}" method="POST" enctype="multipart/form-data">
                      @csrf
                      <div class="row">
                          <div class="col-6">
                              <input type="file" name="file" accept=".csv, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel" required class="form-control">
                          </div>
                          <div class="col-6">
                              <button class="btn btn-success">Import</button>
                              <!-- <a class="btn btn-warning" href="{{ route('admin.export') }}">Export</a> -->
                          </div>
                      </div>
                  </form>
              </div>
          </div>

          <div class="card-body border">
              <h4>Filter</h4>
             
              <div class="row">
                          <div class="col-3">
                          <input class="form-control" value="{{ old('date', date('Y-m-01')) }}" type="date" required name="from" placeholder>
                          </div>
                          <div class="col-3">
                          <input class="form-control" type="date" required name="to" placeholder value="{{ old('date', date('Y-m-d')) }}">
                          </div>
                          <div class="col-3">
                          <select class="form-control" name="status" id="status">
                            <option value="PENDING">PENDING</option>
                            <option value="RING NOT RESPOND">RING NOT RESPOND</option>
                            <option value="OUT OF COVERAGE AREA">OUT OF COVERAGE AREA</option>
                            <option value="SWITCH OFF">SWITCH OFF</option>
                            <option value="CALL BACK">CALL BACK</option>
                            <option value="BUSY">BUSY</option>
                            <option value="INTERESTED">INTERESTED</option>
                            <option value="NOT INTERESTED">NOT INTERESTED</option>
                            <option value="SALE CLOSED">SALE CLOSED</option>
                            <option value="CRITERIA NOT MET">CRITERIA NOT MET</option>
                            </select>
                          </div>
                          <div class="col-3">
                              <button type="submit" class="btn btn-success filter">FILTER DATA</button>
                              <!-- <a class="btn btn-warning" href="{{ route('admin.export') }}">Export</a> -->
                          </div>
                      </div>
             
          </div>
          <div class="table-responsive">
              <br><br>
              <h4>Leads</h4>
              <table class="table">
                  <thead>
                      <tr>
                          <th style="width:10% !important;">Sl.No</th>
                          <th>CUSTOMER NAME</th>
                          <th>Product</th>
                          <th>SOURCE</th>
                          <th>CONTACT NUMBER</th>
                          <th>AGENT</th>
                          <th>STATUS</th>
                          <th>LEAD STATUS</th>
                          <th>Action</th>
                      </tr>
                  </thead>
                  <tbody>

                  </tbody>
              </table>
          </div>
      </div>

  </div>
  <script type="text/javascript">
      $(function() {
          var table = $('.table').DataTable({
              processing: true,
              serverSide: true,
              ajax: {
                            url: "{{ route('admin.get-leads') }}",
                            method:'GET',
                            data: function(d) {
                                d.from = $('input[name="from"]').val();
                                d.to = $('input[name="to"]').val();
                                d.status = $('#status').val();
                            }
                        },
               
              columns: [{
                      data: 'DT_RowIndex',
                      name: 'DT_RowIndex'
                  },
                  {
                      data: 'customer_name',
                      name: 'customer_name'
                  },
                  {
                      data: 'product',
                      name: 'product'
                  },
                  {
                      data: 'source',
                      name: 'source'
                  },
                  {
                      data: 'contact_number',
                      name: 'contact_number'
                  },
                  {
                      data: 'agent_id',
                      name: 'agent_id',
                    //  visible: false
                  },
                  {
                      data: 'status',
                      name: 'status'
                  },
                  {
                      data: 'export_status',
                      name: 'export_status',
                        visible: false
                  },
                 
                  {
                      data: 'action',
                      name: 'action',
                      orderable: false,
                      searchable: false
                  },
              ],
              "select": {
                  'style': 'multi',
                  'selector': 'td:first-child' //only checkbox can select row
              },
              dom: 'Bfrtip',
              buttons: [{
                      extend: 'csv',
                      exportOptions: {
                          columns: [0, 1, 2, 3, 4, 5, 7]
                      }
                  },
                  {
                      extend: 'copy',
                      exportOptions: {
                          columns: [0, 1, 2, 3, 4, 5, 7]
                      }
                  },
                  {
                      extend: 'excel',
                      exportOptions: {
                          columns: [0, 1, 2, 3, 4, 5, 7]
                      }
                  },
                  {
                      extend: 'pdf',
                      exportOptions: {
                          columns: [0, 1, 2, 3, 4, 5, 7]
                      }
                  },
                  {
                      extend: 'print',
                      exportOptions: {
                          columns: [0, 1, 2, 3, 4, 5, 7]
                      }
                  },

              ]
          });
          $(".filter").click(function() {
            table.draw();
        });
      });

      $(document).on('click', '#getDeleteId', function(e) {
          var answer = confirm("Are you sure you want to delete from this item?");
          if (answer) {
              id = $(this).data('id');
              e.preventDefault();
              $.ajaxSetup({
                  headers: {
                      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                  }
              });
              $.ajax({
                  url: "{{ route('admin.delete-lead') }}",
                  method: "GET",
                  data: {
                      'id': id
                  },
                  success: function(result) {
                      $('.table').DataTable().ajax.reload();
                      if (result == 1) {
                          $(".alert-success").text("Lead Deleted successfully.");
                      } else {
                          $(".alert-danger").text("Something went wrong.");
                      }

                      $('.data-table').DataTable().ajax.reload();

                  }
              });
          }
      });

      $(document).on('click', '#leadStatus', function(e) {
          id = $(this).data('id');
          status = $(this).data('value');
          e.preventDefault();
          $.ajaxSetup({
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              }
          });
          $.ajax({
              url: "{{ route('admin.change-lead-status') }}",
              method: "GET",
              data: {
                  'id': id,
                  'status': status
              },
              success: function(result) {
                  $('.table').DataTable().ajax.reload();
                  if (result == 1) {
                      $(".alert-success").text("Status Changed successfully.");
                  } else {
                      $(".alert-danger").text("Something went wrong.");
                  }

                  $('.data-table').DataTable().ajax.reload();

              }
          });
      });

      
  </script>
  @endsection