  @extends('admin.layout.dashboard-template')
  @section('content')
  <style>
      .dropdown-menu {
          top: 64% !important;
          left: 44% !important;
          width: 21%;

      }
  </style>
  <div class="db-info-wrap db-package-wrap">
      <div class="dashboard-box">
          <h4 class="text-center">Booking Details</h4>
          <div class="custom-field-wrap">
              <div class="col-12">
                  <div class="table-responsive">
                      <table class="table" id="booking">
                          <tbody>
                              <tr>
                                  <td>Customer Name</td>
                                  <td> {{$data->customer_name}}</td>
                              </tr>
                              <tr>
                                  <td>Service Name</td>
                                  @php
                                  $service=App\Models\Service::where('id',$data->service_id)->first();
                                  @endphp
                                  <td><a href="{{route('admin.view-service', ['slug' => $service->slug])}}" id="service" data-value="{{$service->title}}">{{$service->title}}</a></td>
                              </tr>
                              <tr>
                                  <td>Agent</td>
                                  @php
                                  $agent=App\Models\User::where('id',$data->agent_id)->first();
                                  @endphp
                                  <td><a href="{{route('admin.view-agent', ['slug' => $agent->slug])}}" id="agent" data-value="{{$agent->id}}">{{$agent->name}}</a></td>
                              </tr>
                              <tr>
                                  <td>Cusomer Phone Number</td>
                                  <td> {{$data->phone_number}}</td>
                              </tr>
                              <tr>
                                  <td>Transaction Number</td>
                                  <td> {{$data->number}}</td>
                              </tr>
                              <tr>
                                  <td>Time</td>
                                  <td> {{$data->service_time}}</td>
                              </tr>
                              <tr>
                                  <td>Date</td>
                                  <td> {{date("d M Y",strtotime($data->service_date))}}</td>
                              </tr>


                              <tr>
                                  <td>Status</td>
                                  @php
                                  if ($data->status == 'Processing') {
                                  $class = "warning";
                                  } elseif ($data->status == 'Approved') {
                                  $class = "success";
                                  } elseif ($data->status == 'Completed') {
                                  $class = "primary disabled";
                                  }elseif ($data->status == 'Declined') {
                        $class = "danger";
                    }
                                  @endphp
                                  <td><a class="btn btn-{{ $class}} dropdown-toggle" style="color:#fff;font-size: 13px;" title="Change Booking Status" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                          {{$data->status}}
                                      </a>

                                      <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                                          <a class="dropdown-item badge badge-warning" data-id="{{$data->id}}" data-value="Processing" id="status" href="#" style="color:#fff;font-size: 13px;">Processing</a>
                                          <a class="dropdown-item badge badge-success" data-id="{{$data->id}}" data-value="Approved" id="status" href="#" style="color:#fff;font-size: 13px;">Approved</a>
                                          <a class="dropdown-item badge badge-primary" data-id="{{$data->id}}" data-value="Completed" id="status" href="#" style="color:#fff;font-size: 13px;">Completed</a>
                                            <a class="dropdown-item badge badge-danger" data-id="{{$data->id}}" data-value="Declined" data-toggle="modal" data-target="#exampleModal"  href="#" style="color:#fff;font-size: 13px;">Declined</a>
                                      </div>

                                  </td>
                               
                              </tr>
                                 <tr>
                                  @if($data->status=='Declined')
                                  <td>Declined Reason </td><td>{{$data->declined_reason}}</td>
                                  @endif
                                  </tr>
                          </tbody>
                      </table>
                      <br><br>

                      @if($data->status=='Processing')
                      <div>
                          <h3>Notes
                              <a href="#" class="btn btn-primary" id="note" style="float:right;" data-toggle="modal" data-target="#myModal">Send Note</a>
                          </h3>
                      </div>
                      @endif
                      @foreach(App\Models\Note::orderBy('id','DESC')->get() as $item)
                      <div class="card" id="card{{$item->id}}">
                          <div class="card-body">
                              {{$item->note}}
                              <a href=" javascript:void(0);" data-id="{{$item->id}}" id="deletenote" href="{{route('admin.delete-note')}}" style="float:right;">Remove Note</a>
                          </div>
                      </div>
                      <br>
                      @endforeach

                      <!-- Modal -->
                      <div class="modal fade" id="myModal" role="dialog">
                          <div class="modal-dialog">

                              <!-- Modal content-->
                              <div class="modal-content">
                                  <form action="{{route('admin.add-note')}}" method="post" class="col-12">
                                      @csrf
                                      <div class="modal-header">
                                          <h4 class="modal-title">Send Note</h4>
                                          <button type="button" class="close" data-dismiss="modal">&times;</button>
                                      </div>
                                      <div class="modal-body">
                                          <textarea name="note" placeholder="Enter note here"></textarea>
                                          <input type="hidden" name="service" value="{{$data->id}}">
                                          <input type="hidden" name="agent" value="{{$data->agent_id}}">
                                      </div>
                                      <div class="modal-footer">
                                          <button type="submit" class="btn btn-primary">Submit</button>
                                      </div>
                                  </form>
                              </div>

 


                          </div>
                      </div>
                  </div>
              </div>
          </div>
      </div>


<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Add Declined Reason</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
      <textarea id="reason" row="3"></textarea>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary" data-dismiss="modal" data-id="{{$data->id}}" data-value="Declined" id="status">Save changes</button>
      </div>
    </div>
  </div>
</div>
</div>

  </div>
  <script>
      $(function() {
          const firebaseConfig = {
              apiKey: "AIzaSyB6261UdgcjJ5vt1fCMZKwpaxCC9qvETjA",
              authDomain: "avosys-92a23.firebaseapp.com",
              projectId: "avosys-92a23",
              storageBucket: "avosys-92a23.appspot.com",
              messagingSenderId: "169283548478",
              appId: "1:169283548478:web:047638c46776caa037a86f",
              measurementId: "G-LB5Q3CSG49"
          };

          firebase.initializeApp(firebaseConfig);
          const messaging = firebase.messaging();

          $('#allow_not_btn').on('click', function() {
              messaging
                  .requestPermission()
                  .then(function() {
                      return messaging.getToken()
                  })
                  .then(function(response) {
                      $.ajaxSetup({
                          headers: {
                              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                          }
                      });
                      $.ajax({
                          url: '{{ route("admin.save-token") }}',
                          type: 'POST',
                          data: {
                              token: response,
                              agent_id: $('#agent').data('value')
                          },
                          dataType: 'JSON',
                          success: function(response) {
                              alert('Token stored.');
                          },
                          error: function(error) {
                              alert(error);
                          },
                      });

                  }).catch(function(error) {
                      alert(error);
                  });
          });

          messaging.onMessage(function(payload) {
              const title = payload.notification.title;
              const options = {
                  body: payload.notification.body,
                  icon: payload.notification.icon,
              };
              new Notification(title, options);
          });
      });

      $(document).on('click', '#status', function(e) {
          id = $(this).data('id');
          status = $(this).data('value');
          reason = $('#reason').val();
          service = $('#service').data('value');
          agent = $('#agent').data('value');
          customer = "<?php echo $data->customer_name; ?>";
          msg = 'Application for ' + service + ' of ' + customer + ' has been ' + status;
          e.preventDefault();
          $.ajaxSetup({
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              }
          });
          $.ajax({
              url: "{{ route('admin.change-enquiry-status') }}",
              method: "GET",
              data: {
                  'id': id,
                  'status': status,
                  'reason':reason
              },
              success: function(result) {
                  $("#booking").load(" #booking > *");
                  if (status == 'Processing') {
                      $("#note").show();
                  } else {
                      $("#note").hide();
                  }

                  if (result.status && status != 'Processing') {
                      $.ajax({
                          url: "{{ route('admin.send-notification') }}",
                          method: "POST",
                          data: {
                              "_token": "{{ csrf_token() }}",
                              'agent_id': agent,
                              'title': 'Application ' + status,
                              'body': msg
                          },
                          success: function(result) {
                              console.log(result);
                          }
                      });
                  }
              }
          });
      });

      $(document).on('click', '#deletenote', function(e) {
          id = $(this).data('id');
          e.preventDefault();
          $.ajaxSetup({
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              }
          });
          $.ajax({
              url: "{{ route('admin.delete-note') }}",
              method: "GET",
              data: {
                  'id': id
              },
              success: function(result) {
                  $('#card' + id).hide('slow');

              }
          });
      });
  </script>
  @endsection