@extends('admin.layout.dashboard-template')
@section('content')

<div class="db-info-wrap">
    <div class="row">

        <div class="col-xl-4 col-sm-6">
            <a href="{{route('admin.agents')}}">
                <div class="db-info-list">
                    <div class="dashboard-stat-icon bg-blue">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="dashboard-stat-content">
                        <h4>Agents</h4>
                        <h5>{{count(App\Models\User::get())}}</h5>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-xl-4 col-sm-6">
            <a href="{{route('admin.service')}}">
                <div class="db-info-list">
                    <div class="dashboard-stat-icon bg-green">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="dashboard-stat-content">
                        <h4>Services</h4>
                        <h5>{{count(App\Models\Service::get())}}</h5>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-xl-4 col-sm-6">
            <a href="{{route('admin.enquiry')}}">
                <div class="db-info-list">
                    <div class="dashboard-stat-icon bg-purple">
                        <i class="fas fa-box"></i>
                    </div>
                    <div class="dashboard-stat-content">
                        <h4>Applications</h4>
                        <h5>{{count(App\Models\ServiceBooking::get())}}</h5>
                    </div>
                </div>
            </a>
        </div>


    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="dashboard-box table-opp-color-box">
                <h4>Recent Applications</h4>
                @if(\Session::get('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <div class="alert-body">
                        {{ \Session::get('success') }}
                    </div>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                @endif
                {{ \Session::forget('success') }}
                @if(\Session::get('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <div class="alert-body">
                        {{ \Session::get('error') }}
                    </div>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                @endif
                <div class="table-responsive">
                    <table class="table booking dataTable no-footer" id="booking" role="grid" aria-describedby="DataTables_Table_0_info" style="width: 953px;">
                        <thead>
                            <tr role="row">
                                <th class="sorting_asc" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Sl.No: activate to sort column descending" style="width: 77px;">Sl.No</th>
                                <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1" colspan="1" aria-label="USER: activate to sort column ascending" style="width: 71px;">Customer Name</th>
                                <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1" colspan="1" aria-label="PACKAGE: activate to sort column ascending" style="width: 205px;">Phone Number</th>
                                <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1" colspan="1" aria-label="NO:DAYS: activate to sort column ascending" style="width: 103px;">Service</th>
                                <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1" colspan="1" aria-label="NO:DAYS: activate to sort column ascending" style="width: 103px;">Agent</th>
                                <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1" colspan="1" aria-label="Status: activate to sort column ascending" style="width: 127px;">Status</th>
                                <th class="sorting_disabled" rowspan="1" colspan="1" aria-label="Action" style="width: 94px;">Action</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>
<script type="text/javascript">
    $(function() {
        var table = $('.table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('admin.get-enquiry') }}",
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex'
                },
                {
                    data: 'customer_name',
                    name: 'customer_name'
                },
                {
                    data: 'phone_number',
                    name: 'phone_number'
                },
                {
                    data: 'service',
                    name: 'service'
                },
                {
                    data: 'agent',
                    name: 'agent'
                },
                {
                    data: 'status',
                    name: 'status'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                },
            ],
            "select": {
                'style': 'multi',
                'selector': 'td:first-child' //only checkbox can select row
            },
        });

    });

    $(document).on('click', '#getBookingDeleteID', function(e) {
        var answer = confirm("Are you sure you want to delete from this item?");
        if (answer) {
            id = $(this).data('id');
            e.preventDefault();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('admin.delete-enquiry') }}",
                method: "GET",
                data: {
                    'id': id
                },
                success: function(result) {
                    $('.table').DataTable().ajax.reload();
                    if (result == 1) {
                        $(".alert-success").text("Service Deleted successfully.");
                    } else {
                        $(".alert-danger").text("Something went wrong.");
                    }

                }
            });
        }
    });
</script>
@endsection