  @extends('admin.layout.dashboard-template')
  @section('content')

  <div class="db-info-wrap db-add-tour-wrap">
      <div class="row">

          <form action="{{route('admin.update-password')}}" method="post" enctype="multipart/form-data" class="col-12">
              @csrf
              <!-- Listings -->
              <div class="col-md-8 offset-md-2" style="margin-bottom:110px;">
                  @if(\Session::get('success'))
                  <div class="alert alert-success alert-dismissible fade show" role="alert">
                      <div class="alert-body">
                          {{ \Session::get('success') }}
                      </div>
                      <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close">x</button>
                  </div>
                  @endif
                  {{ \Session::forget('success') }}
                  @if(\Session::get('error'))
                  <div class="alert alert-danger alert-dismissible fade show" role="alert">
                      <div class="alert-body">
                          {{ \Session::get('error') }}
                      </div>
                      <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close">x</button>
                  </div>
                  @endif
                  <div class="dashboard-box">
                      <h4>Reset Password</h4>
                      <div class="custom-field-wrap">

                          <div class="row">
                              <div class="col-12">
                                  <div class="form-group">
                                      <label>New password</label>
                                      <input type="password" name="password" value="{{ old('password') }}">
                                      @if ($errors->has('password'))
                                      <span class="help-block font-red-mint">
                                          <strong>{{ $errors->first('password') }}</strong>
                                      </span>
                                      @endif
                                  </div>
                              </div>
                              <div class="col-12">
                                  <div class="form-group">
                                      <label>Confirm Password</label>
                                      <input type="password" name="confirm_password" value="{{ old('confirm_password') }}">
                                      @if ($errors->has('confirm_password'))
                                      <span class="help-block font-red-mint">
                                          <strong>{{ $errors->first('confirm_password') }}</strong>
                                      </span>
                                      @endif
                                  </div>
                              </div>
                          </div>


                          <div class="col-12 text-center">
                              <button type="submit" id="add" class="btn btn-primary">Change Password</button>
                          </div>
                      </div>
          </form>
      </div>
  </div>


  @endsection