@extends('admin.layout.template')
@section('content')

<body>
    <div class="login-page" style="background-image: url('{{asset('assets/images/bg.jpg')}}');">
        <div class="login-from-wrap">
            @if(\Session::get('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <div class="alert-body">
                    {{ \Session::get('success') }}
                </div>
                <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
            </div>
            @endif
            {{ \Session::forget('success') }}
            @if(\Session::get('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <div class="alert-body">
                    {{ \Session::get('error') }}
                </div>
                <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
            </div>
            @endif
            <form class="login-from" action="{{route('admin.adminLoginPost')}}" method="post">
                @csrf
                <h1 class="site-title" style="background:#000;padding:10px 0px;">
                    <a href="#">
                        <img src="{{asset('assets/images/logo.png')}}" alt="">
                    </a>
                </h1>
                <div class="form-group">
                    <label for="first_name1">User Name</label>
                    <input type="text" class="validate" id="email" name="email" value="{{old('email') }}" autofocus />
                    @if ($errors->has('email'))
                    <span class="help-block font-red-mint">
                        <strong>{{ $errors->first('email') }}</strong>
                    </span>
                    @endif
                </div>
                <div class="form-group">
                    <label for="last_name">Password</label>
                    <input type="password" class="validate" id="password" name="password">
                    @if ($errors->has('password'))
                    <span class="help-block font-red-mint">
                        <strong>{{ $errors->first('password') }}</strong>
                    </span>
                    @endif
                </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-dark ">Login</button>
                </div>
                <a href="{{ route('admin.forget-password-get') }}" class="for-pass">Forgot Password?</a>
            </form>
        </div>
    </div>

    @endsection