  @extends('admin.layout.dashboard-template')
  @section('content')

  <div class="db-info-wrap db-package-wrap">
      <div class="dashboard-box table-opp-color-box">
          <h4>Agents</h4>
          <div class="text-right">
              <a href="{{route('admin.add-agent')}}" class="btn btn-success mtb">ADD AGENT</a>
          </div>
          
                <div class="card mb-5">
              <div class=" card-body">
                  <h4>Add Bulk Agents</h4>
                  <form action="{{ route('admin.import-agents') }}" method="POST" enctype="multipart/form-data">
                      @csrf
                      <div class="row">
                          <div class="col-6">
                              <input class="form-control" type="file" id="formFileDisabled" name="file" accept=".csv, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel" required />
                              <!-- <input type="file" name="file" accept=".csv, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel" required> -->
                          </div>
                          <div class="col-6">
                              <button class="btn btn-success">Import</button>
                          </div>
                      </div>
                  </form>
              </div>
          </div>
          
          @if(\Session::get('success'))
          <div class="alert alert-success alert-dismissible fade show" role="alert">
              <div class="alert-body">
                  {{ \Session::get('success') }}
              </div>
              <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
          </div>
          @endif
          {{ \Session::forget('success') }}
          @if(\Session::get('error'))
          <div class="alert alert-danger alert-dismissible fade show" role="alert">
              <div class="alert-body">
                  {{ \Session::get('error') }}
              </div>
              <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">x</button>
          </div>
          @endif
          <div class="table-responsive">
              <table class="table text-center">
                  <thead>
                      <tr>
                          <th>Sl<br>No</th>
                          <th>ID</th>
                          <th>Name</th>
                          <th>Mobile<br> Number</th>
                          <th>Email</th>
                          <th>Total <br>commission</th>
                          <th>Status</th>
                          <th>Action</th>
                      </tr>
                  </thead>
                  <tbody>
                      <!-- <tr role="row" class="odd">
                          <td class="sorting_1">1</td>
                          <td><span class="package-name">manu mathew</span></td>
                          <td>9188360233</td>
                          <td>manu@gmail.com</td>
                          <td><span class="badge badge-primary">350</span></td>
                          <td><a href="javascript:void(0)" data-id="26" data-value="0" id="status"><span class="badge badge-danger">Inactive</span></a></td>
                          <td> <a href="{{route('admin.agent-view')}}" class="text-muted"> <span class="badge badge-success"><i class="far fa-eye"></i></span></a>
                              <a href="javascript:void(0);" class="text-muted"> <span class="badge badge-success"><i class="far fa-edit"></i></span></a>
                              <a href="javascript:void(0);" data-id="26" id="getDeleteId" class="text-muted"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>
                          </td>
                      </tr> -->

                  </tbody>
              </table>
          </div>
      </div>
      <!-- Modal -->
      <div class="modal fade" id="myModal" role="dialog">
          <div class="modal-dialog">

              <!-- Modal content-->
              <div class="modal-content">
                  <div class="modal-header">

                      <h4 class="modal-title">Add Agent</h4>
                      <button type="button" class="close" data-dismiss="modal">&times;</button>
                  </div>
                  <div class="modal-body">
                      <form action="{{route('admin.save-agent')}}" method="post" enctype="multipart/form-data" class="col-12">
                          @csrf
                          <div class="row">
                              <div class="col-md-6 offset-md-4 ">
                                  <div class="form-group">
                                      <!-- <label>Upload profile photo</label> -->
                                      <div class="avatar-upload">
                                          <div class="avatar-edit">
                                              <input type='file' name="image" id="imageUpload" accept=".png, .jpg, .jpeg" />
                                              <label for="imageUpload"><i class="fa fa-camera" style="margin:11px 3px 0px 8px;"></i></label>
                                          </div>
                                          <div class=" avatar-preview">
                                              <div id="imagePreview" style="background-image: url(/assets/images/profile-image.jpg);">
                                              </div>
                                          </div>
                                      </div>
                                      <!-- <input type="file" name="image" class="form-control"> -->
                                  </div>
                              </div>
                          </div>
                          <div class="row">
                              <div class="col-12">
                                  <div class="form-group">
                                      <label>Agent Full Name</label>
                                      <input type="text" name="name" class="form-control">
                                  </div>
                              </div>
                          </div>
                          <div class="row">
                              <div class="col-12">
                                  <div class="form-group">
                                      <label>Agent Phone number</label>
                                      <input type="text" name="mobile_number" class="form-control">
                                  </div>
                              </div>
                          </div>
                          <div class="row">
                              <div class="col-12">
                                  <div class="form-group">
                                      <label>Agent Mail ID</label>
                                      <input type="text" name="email" class="form-control">
                                  </div>
                              </div>
                          </div>

                          <div class="row">
                              <div class="col-12 text-center">

                                  <button type="submit" class="btn btn-primary">Submit</button>
                              </div>
                          </div>
                      </form>
                  </div>
              </div>

          </div>

      </div>
  </div>
  </div>
  <script type="text/javascript">
      $(function() {

          var table = $('.table').DataTable({
              processing: true,
              serverSide: true,
              ajax: "{{ route('admin.get-agent') }}",
              columns: [{
                      data: 'DT_RowIndex',
                      name: 'DT_RowIndex'
                  },
                  {
                      data: 'id',
                      name: 'id'
                  },
                  {
                      data: 'name',
                      name: 'name'
                  },
                  {
                      data: 'number',
                      name: 'number'
                  },
                  {
                      data: 'email',
                      name: 'email'
                  },

                  {
                      data: 'commission',
                      name: 'commission'
                  },
                  {
                      data: 'status',
                      name: 'status'
                  },
                  {
                      data: 'action',
                      name: 'action',
                      orderable: false,
                      searchable: false
                  },
              ],
              "select": {
                  'style': 'multi',
                  'selector': 'td:first-child' //only checkbox can select row
              },
          });

      });
      $(document).on('click', '#status', function(e) {
          id = $(this).data('id');
          status = $(this).data('value');
          e.preventDefault();
          $.ajaxSetup({
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              }
          });
          $.ajax({
              url: "{{ route('admin.change-agent-status') }}",
              method: "GET",
              data: {
                  'id': id,
                  'status': status
              },
              success: function(result) {
                  $('.table').DataTable().ajax.reload();
                  if (result == 1) {
                      $(".alert-success").text("Status Changed successfully.");
                  } else {
                      $(".alert-danger").text("Something went wrong.");
                  }

                  $('.data-table').DataTable().ajax.reload();

              }
          });
      });
      $(document).on('click', '#getDeleteId', function(e) {
          var answer = confirm("Are you sure you want to delete from this item?");
          if (answer) {
              id = $(this).data('id');
              e.preventDefault();
              $.ajaxSetup({
                  headers: {
                      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                  }
              });
              $.ajax({
                  url: "{{ route('admin.delete-agent') }}",
                  method: "GET",
                  data: {
                      'id': id
                  },
                  success: function(result) {
                      $('.table').DataTable().ajax.reload();
                      if (result == 1) {
                          $(".alert-success").text("Package Deleted successfully.");
                      } else {
                          $(".alert-danger").text("Something went wrong.");
                      }

                      $('.data-table').DataTable().ajax.reload();

                  }
              });
          }
      });

      function readURL(input) {
          if (input.files && input.files[0]) {
              var reader = new FileReader();
              reader.onload = function(e) {
                  $('#imagePreview').css('background-image', 'url(' + e.target.result + ')');
                  $('#imagePreview').hide();
                  $('#imagePreview').fadeIn(650);
              }
              reader.readAsDataURL(input.files[0]);
          }
      }
      $("#imageUpload").change(function() {
          readURL(this);
      });
  </script>
  @endsection