  @extends('admin.layout.dashboard-template')
  @section('content')

  <div class="db-info-wrap db-add-tour-wrap">
      <div class="row">
          <!-- Listings -->
          <div class="col-lg-12 col-xl-12">
              @if(\Session::get('success'))
              <div class="alert alert-success alert-dismissible fade show" role="alert">
                  <div class="alert-body">
                      {{ \Session::get('success') }}
                  </div>
                  <button type="button" class="btn-close " data-dismiss="alert" aria-label="Close"></button>
              </div>
              @endif
              {{ \Session::forget('success') }}
              @if(\Session::get('error'))
              <div class="alert alert-danger alert-dismissible fade show" role="alert">
                  <div class="alert-body">
                      {{ \Session::get('error') }}
                  </div>
                  <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
              </div>
              @endif
              <div class="dashboard-box">
                  <h4 class="text-center">Edit Agents </h4>
                  <div class="col-md-8 offset-md-2">
                      <form action=" {{route('admin.update-agent')}}" method="post" enctype="multipart/form-data" class="col-12">
                          @csrf
                          <div class="row">
                              <div class="col-md-5 offset-md-5 ">
                                  <div class="form-group">
                                      <!-- <label>Upload profile photo</label> -->
                                      <div class="avatar-upload">
                                          <div class="avatar-edit">
                                              <input type='file' id="imageUpload" accept=".png, .jpg, .jpeg" name="image" />
                                              <label for="imageUpload"><i class="fa fa-camera" style="margin:11px 3px 0px 8px;"></i></label>
                                          </div>
                                          <div class=" avatar-preview">
                                              @if($data->image!=NULL)
                                              <div id="imagePreview" style="background-image: url('{{asset('uploads/agent/'.$data->image)}}');">
                                                  @else
                                                  <div id="imagePreview" style="background-image: url('{{asset('assets/images/default-image.jpg')}}');">
                                                      @endif

                                                  </div>
                                              </div>
                                          </div>

                                      </div>
                                  </div>
                              </div>
                              <div class="row">
                                  <div class="col-12">
                                      <div class="form-group">
                                          <label>Agent Full Name</label>
                                          <input type="text" required name="name" value="{{$data->name}}" class="form-control">
                                          <input type="hidden" value="{{$data->id}}" name="id">
                                          @if ($errors->has('name'))
                                          <span class="help-block font-red-mint">
                                              <strong>{{ $errors->first('name') }}</strong>
                                          </span>
                                          @endif
                                      </div>
                                  </div>
                              </div>
                              <div class="row">
                                  <div class="col-12">
                                      <div class="form-group">
                                          <label>Agent Phone number</label>
                                          <input type="text" required name="mobile_number" id="mobile_number" minlength="10" maxlength="10" value="{{$data->mobile_number}}" class=" form-control">
                                          <span class="help-block font-red-mint" id="number_error">

                                          </span>
                                          @if ($errors->has('mobile_number'))
                                          <span class="help-block font-red-mint">
                                              <strong>{{ $errors->first('mobile_number') }}</strong>
                                          </span>
                                          @endif
                                      </div>
                                  </div>
                              </div>
                              <div class="row">
                                  <div class="col-12">
                                      <div class="form-group">
                                          <label>Agent Mail ID</label>
                                          <input type="email" required name="email" id="email" value="{{$data->email}}" class="form-control">
                                          <span class="help-block font-red-mint" id="mail_error">

                                          </span>
                                          @if ($errors->has('email'))
                                          <span class="help-block font-red-mint">
                                              <strong>{{ $errors->first('email') }}</strong>
                                          </span>
                                          @endif
                                      </div>
                                  </div>
                              </div>

                              <div class="row">
                                  <div class="col-12">
                                      <div class="form-group">
                                          <label><span style="color:red">* </span>Designation</label>
                                          <select required name="designation" id="designation" class="form-control">
                                              <option value="Business Consultant" {{ $data->designation =='Business Consultant'  ? 'selected' : '' }}>Business Consultant</option>
                                              <option value="Sr.Business Consultant" {{ $data->designation =='Sr.Business Consultant'  ? 'selected' : '' }}>Sr.Business Consultant</option>
                                          </select>
                                          <span class="help-block font-red-mint" id="mail_error">

                                          </span>
                                          @if ($errors->has('designation'))
                                          <span class="help-block font-red-mint">
                                              <strong>{{ $errors->first('designation') }}</strong>
                                          </span>
                                          @endif
                                      </div>
                                  </div>
                              </div>
                              
                                  <div class="row">
                                  <div class="col-12">
                                      <div class="form-group">
                                          <label>Gpay number</label>
                                          <input type="text" required name="gpay_name" value="{{$data->gpay_name}}" class="form-control">
                                          <input type="hidden"  name="id">
                                          @if ($errors->has('gpay_name'))
                                          <span class="help-block font-red-mint">
                                              <strong>{{ $errors->first('gpay_name') }}</strong>
                                          </span>
                                          @endif
                                      </div>
                                  </div>
                              </div>
                              <div class="row">
                                  <div class="col-12">
                                      <div class="form-group">
                                          <label>Gpay Name</label>
                                          <input type="text" required name="gpay_number" id="gpay_number" minlength="10" maxlength="10" value="{{$data->gpay_number}}" class=" form-control">
                                          <span class="help-block font-red-mint" id="number_error">

                                          </span>
                                          @if ($errors->has('gpay_number'))
                                          <span class="help-block font-red-mint">
                                              <strong>{{ $errors->first('gpay_number') }}</strong>
                                          </span>
                                          @endif
                                      </div>
                                  </div>
                              </div>

                              <div class="row">
                                  <div class="col-12 text-center">
                                      <button type="submit" id="submit" class="btn btn-primary">Submit</button>
                                  </div>
                              </div>
                      </form>
                  </div>
              </div>
          </div>

      </div>
  </div>
  <script>
      $(document).on('keyup', '#mobile_number', function(e) {
          $("#number_error").empty();
          $current_number = "<?php echo $data->mobile_number; ?>";
          number = $('#mobile_number').val();
          if (!$('#mobile_number').val().match('[0-9]{10}')) {
              $("#number_error").text("Please put 10 digit mobile number");

          }
          e.preventDefault();
          $.ajaxSetup({
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              }
          });
          if (number != $current_number) {
              $.ajax({
                  url: "{{ route('admin.check-number-exist') }}",
                  method: "GET",
                  data: {
                      'number': number
                  },
                  success: function(result) {
                      if (result == 1) {
                          $('#submit').attr("disabled", true);
                          $("#number_error").text(" This mobile number is already exist. Please enter another number.");
                      } else {
                          if ($("#mail_error").text() == "") {
                              $('#submit').removeAttr("disabled");
                          }
                      }

                  }
              });
          }
      });
      $(document).on('keyup', '#email', function(e) {
          $("#mail_error").empty();
          email = $('#email').val();
          $current_mail = "<?php echo $data->email; ?>";
          e.preventDefault();
          $.ajaxSetup({
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              }
          });
          if (email != $current_mail) {
              $.ajax({
                  url: "{{ route('admin.check-email-exist') }}",
                  method: "GET",
                  data: {
                      'email': email
                  },
                  success: function(result) {
                      if (result == 1) {
                          $('#submit').attr("disabled", true);
                          $("#mail_error").text(" This Mail ID is already exist. Please enter another mail id.");
                      } else {
                          if ($("#number_error").text() == "") {
                              $('#submit').removeAttr("disabled");
                          }
                      }

                  }
              });
          }
      });

      function readURL(input) {
          if (input.files && input.files[0]) {
              var reader = new FileReader();
              reader.onload = function(e) {
                  $('#imagePreview').css('background-image', 'url(' + e.target.result + ')');
                  $('#imagePreview').hide();
                  $('#imagePreview').fadeIn(650);
              }
              reader.readAsDataURL(input.files[0]);
          }
      }
      $("#imageUpload").change(function() {
          readURL(this);
      });
  </script>

  @endsection