  @extends('admin.layout.dashboard-template')
  @section('content')

  <div class="db-info-wrap db-add-tour-wrap">
      <div class="row">
          <!-- Listings -->
          <div class="col-lg-12 col-xl-12">
              @if(\Session::get('success'))
              <div class="alert alert-success alert-dismissible fade show" role="alert">
                  <div class="alert-body">
                      {{ \Session::get('success') }}
                  </div>
                  <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
              </div>
              @endif
              {{ \Session::forget('success') }}

              <!--   @if($errors->any())
              <div class="alert alert-danger">
                  <ul class="list-unstyled">
                      @foreach ($errors->all() as $error)
                      <li>{{ $error }}</li>
                      @endforeach
                  </ul>
              </div>
              @endif -->

              <div class="dashboard-box">
                  <h4>Add Agents </h4>
                  <div class="col-md-8 offset-md-2">
                      <form action=" {{route('admin.save-agent')}}" method="post" enctype="multipart/form-data" class="col-12">
                          @csrf
                          <div class="row">
                              <div class="col-md-5 offset-md-5 ">
                                  <div class="form-group">
                                      <!-- <label>Upload profile photo</label> -->
                                      <div class="avatar-upload">
                                          <div class="avatar-edit">
                                              <input type='file' name="image" value="{{ old('image') }}" id="imageUpload" accept=".png, .jpg, .jpeg" />
                                              <label for="imageUpload"><i class="fa fa-camera" style="margin:11px 3px 0px 8px;"></i></label>
                                          </div>
                                          <div class=" avatar-preview">
                                              <div id="imagePreview" style="background-image: url(assets/images/profile-image.jpg);">
                                              </div>

                                          </div>

                                      </div>

                                  </div>
                              </div>
                          </div>
                          <div class="row">
                              <div class="col-12">
                                  <div class="form-group">
                                      <label><span style="color:red">* </span>Agent Full Name </label>
                                      <input type="text" required name="name" value="{{ old('name') }}" class="form-control">
                                      @if ($errors->has('name'))
                                      <span class="help-block font-red-mint">
                                          <strong>{{ $errors->first('name') }}</strong>
                                      </span>
                                      @endif
                                  </div>
                              </div>
                          </div>
                          <div class="row">
                              <div class="col-12">
                                  <div class="form-group">
                                      <label><span style="color:red">* </span>Agent Phone number</label>
                                      <input type="text" required name="mobile_number" id="mobile_number" value="{{ old('mobile_number') }}" minlength="10" maxlength="10" class=" form-control">
                                      <span class="help-block font-red-mint" id="number_error">

                                      </span>
                                      @if ($errors->has('mobile_number'))
                                      <span class="help-block font-red-mint">
                                          <strong>{{ $errors->first('mobile_number') }}</strong>
                                      </span>
                                      @endif
                                  </div>
                              </div>
                          </div>
                          <div class="row">
                              <div class="col-12">
                                  <div class="form-group">
                                      <label><span style="color:red">* </span>Agent Mail ID</label>
                                      <input type="email" required name="email" value="{{ old('email') }}" id="email" class="form-control">
                                      <span class="help-block font-red-mint" id="mail_error">

                                      </span>
                                      @if ($errors->has('email'))
                                      <span class="help-block font-red-mint">
                                          <strong>{{ $errors->first('email') }}</strong>
                                      </span>
                                      @endif
                                  </div>
                              </div>
                          </div>

                          <div class="row">
                              <div class="col-12">
                                  <div class="form-group">
                                      <label><span style="color:red">* </span>Designation</label>
                                      <select required name="designation" id="designation" class="form-control">
                                          <option value="Business Consultant">Business Consultant</option>
                                          <option value="Sr.Business Consultant">Sr.Business Consultant</option>
                                      </select>

                                  </div>
                              </div>
                          </div>


    <div class="row">
                                  <div class="col-12">
                                      <div class="form-group">
                                          <label>Gpay number</label>
                                          <input type="text"  name="gpay_name"  class="form-control">
                                          <input type="hidden"  name="id">
                                          @if ($errors->has('gpay_name'))
                                          <span class="help-block font-red-mint">
                                              <strong>{{ $errors->first('gpay_name') }}</strong>
                                          </span>
                                          @endif
                                      </div>
                                  </div>
                              </div>
                              <div class="row">
                                  <div class="col-12">
                                      <div class="form-group">
                                          <label>Gpay Name</label>
                                          <input type="text"  name="gpay_number" id="gpay_number" minlength="10" maxlength="10"  class=" form-control">
                                          <span class="help-block font-red-mint" id="number_error">

                                          </span>
                                          @if ($errors->has('gpay_number'))
                                          <span class="help-block font-red-mint">
                                              <strong>{{ $errors->first('gpay_number') }}</strong>
                                          </span>
                                          @endif
                                      </div>
                                  </div>
                              </div>
                              
                          <div class="row">
                              <div class="col-12 text-center">
                                  <button type="submit" id="submit" class="btn btn-primary">Submit</button>
                              </div>
                          </div>
                      </form>
                  </div>
              </div>
          </div>

      </div>
  </div>
  <script>
      function readURL(input) {
          if (input.files && input.files[0]) {
              var reader = new FileReader();
              reader.onload = function(e) {
                  $('#imagePreview').css('background-image', 'url(' + e.target.result + ')');
                  $('#imagePreview').hide();
                  $('#imagePreview').fadeIn(650);
              }
              reader.readAsDataURL(input.files[0]);
          }
      }
      $("#imageUpload").change(function() {
          readURL(this);
      });

      $(document).on('keyup', '#mobile_number', function(e) {
          $("#number_error").empty();

          number = $('#mobile_number').val();
          if (!$('#mobile_number').val().match('[0-9]{10}')) {
              $("#number_error").text("Please put 10 digit mobile number");

          }
          e.preventDefault();
          $.ajaxSetup({
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              }
          });
          $.ajax({
              url: "{{ route('admin.check-number-exist') }}",
              method: "GET",
              data: {
                  'number': number
              },
              success: function(result) {
                  if (result == 1) {
                      $('#submit').attr("disabled", true);
                      $("#number_error").text(" This mobile number is already exist. Please enter another number.");
                  } else {
                      if ($("#mail_error").text() == "") {
                          $('#submit').removeAttr("disabled");
                      }
                  }

              }
          });
      });
      $(document).on('keyup', '#email', function(e) {
          $("#mail_error").empty();
          email = $('#email').val();
          e.preventDefault();
          $.ajaxSetup({
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              }
          });
          $.ajax({
              url: "{{ route('admin.check-email-exist') }}",
              method: "GET",
              data: {
                  'email': email
              },
              success: function(result) {
                  if (result == 1) {
                      $('#submit').attr("disabled", true);
                      $("#mail_error").text(" This Mail ID is already exist. Please enter another mail id.");
                  } else {
                      if ($("#number_error").text() == "") {
                          $('#submit').removeAttr("disabled");
                      }
                  }

              }
          });
      });
  </script>

  @endsection