<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Cviebrock\EloquentSluggable\Sluggable;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;
    use Sluggable;
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */

    protected $fillable = [
        'name',
        'slug',
        'type',
        'email',
        'password',
        'mobile_number',
         'employeeID',
        'designation',
        'refrence_code',
        'otp',
        'otp_expiry_time',
        'image',
        'device_token',
        'status'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
    
     public function sluggable():array
    {
        return [
            'slug' => [
                'source' => 'title'
            ]
        ];
    }
    
    
    public function leads()
    {
        return $this->hasMany(Leads::class, 'agent_id');
    }
    
        
    public function hotleads()
    {
        return $this->hasMany(HotLeads::class, 'agent_id');
    }
    
        public function generations()
    {
        return $this->hasMany(DataGeneration::class, 'agent_id');
    }
    
    public function serviceBooking()
    {
        return $this->hasMany('App\Models\ServiceBooking', 'agent_id');
    }
    // public function sendPasswordResetNotification($token)
    // {
    //     $this->notify(new \App\Notifications\MailResetPasswordNotification($token));
    // }
    
    
   
}
