<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;

class Service extends Model
{
    use HasFactory;
    use Sluggable;
    protected $table = 'services';
    protected $fillable = ['title', 'slug', 'code', 'description', 'commission', 'image', 'status'];
    public function links()
    {
        return $this->hasMany('App\Models\UsefulLinks', 'service_id');
    }
    public function tutorialLinks()
    {
        return $this->hasMany('App\Models\TutorialLinks', 'service_id');
    }
    public function bookings()
    {
        return $this->hasMany('App\Models\ServiceBooking', 'id');
    }
    public function banner()
    {
        return $this->hasMany('App\Models\Banners', 'id');
    }
    public function sluggable():array
    {
        return [
            'slug' => [
                'source' => 'title'
            ]
        ];
    }
}
