<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Laravel\Sanctum\HasApiTokens;
use Cviebrock\EloquentSluggable\Sluggable;

class DataGeneration extends Model
{
    use HasFactory, HasApiTokens;
    use Sluggable;
    protected $fillable = [
        'full_name',
        'mobile_number',
        'company_name',
        'approximate_salary',
        'Location',
        'agent_id'
    ];

    public function agent()
    {
        return $this->belongsTo(User::class);
    }

    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'title'
            ]
        ];
    }
}
