<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AddTutorialLinks;
use Illuminate\Database\QueryException;
use \Yajra\Datatables\Datatables;

class TutorialLinkController extends Controller
{
    public function saveTutorialLink(Request $request)
    {

        $request->validate([
            'title' => 'required',
            'link' => 'required'
        ]);

        try {
            $TutorialLinks = new AddTutorialLinks();
            $TutorialLinks->title = $request->title;
            $TutorialLinks->link = $request->link;
            $res =  $TutorialLinks->save();
            if ($res == 1) {

                return back()->with('success', "TutorialLinks Added Successfully");
            } else {
                return back()->with('error', "Something Wrong");
            }
        } catch (QueryException $e) {

            return back()->with('error', $e->getMessage());
        }
    }
    public function updateTutorialLink(Request $request)
    {

        $request->validate([
            'title' => 'required',
            'link' => 'required'
        ]);

        try {
            $res = AddTutorialLinks::where('id', $request->id)
                ->update([
                    'title' => $request->title,
                    'link' => $request->link
                ]);

            if ($res == 1) {

                return back()->with('success', "TutorialLinks Updated Successfully");
            } else {
                return back()->with('error', "Something Wrong");
            }
        } catch (QueryException $e) {

            return back()->with('error', $e->getMessage());
        }
    }
    public function getTutorialLink(Request $request)
    {
        if ($request->ajax()) {
            $data = AddTutorialLinks::orderBy('id', 'DESC')->get();
            // print_r($data);
            // die();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = ' 
                    <a href="' . route('admin.edit-tutorialLink', ['id' => $data->id]) . '"  class="text-muted"> <span class="badge badge-success"><i class="far fa-edit"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('title', function ($data) {
                    return $data->title;
                })
                ->addColumn('link', function ($data) {
                    return $data->link;
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function deleteTutorialLink(Request $request)
    {
        $res = AddTutorialLinks::where('id', $request->id)->delete();
        return $res;
    }

    public function editTutorialLink(Request $request)
    {
        $res = AddTutorialLinks::where('id', $request->id)->first();
        return view('admin.tutorialLink.edit', ['data' => $res]);
    }
}
