<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Models\Admin;
use Validator;

class LoginController extends Controller
{
    public function index()
    {
        return view('admin.auth.login');
    }
    public function resetPassword()
    {
        return view('admin.auth.reset-password');
    }
    public function updatePassword(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'password' => 'required|string|min:6',
            'confirm_password' => 'required|confirmed'
        ]);

        if ($validator->fails()) {
            $errors = $validator->errors();
            return redirect()->back()->withErrors($errors);
        }

        if ($request->password == $request->confirm_password) {
            $res =   Admin::where('id', Session::get('user')->id)
                ->update([
                    'password' => bcrypt($request->password)
                ]);
            if ($res == 1) {
                return back()->with('success', "Password updated Successfully");
            } else {
                return back()->with('error', "Something Wrong");
            }
        } else {
            return back()->with('error', "Password dose not match.");
        }
    }
    public function dashboard()
    {
        return view('admin.dashboard');
    }
    public function postLogin(Request $request)
    {
        $this->validate($request, [
            'email' => 'required|email',
            'password' => 'required',
        ]);

        if (auth()->guard('admin')->attempt(['email' => $request->input('email'),  'password' => $request->input('password')])) {
            $res =   Admin::where('email', $request->email)
                ->update([
                    'last_logged_in' => now()
                ]);
            $user = auth()->guard('admin')->user();
            Session::put('user', $user);
            if ($user->is_admin == 1) {
                return redirect()->route('admin.adminDashboard')->with('success', 'You are Logged in sucessfully.');
            }
        } else {
            return back()->with('error', 'Whoops! invalid email and password.');
        }
    }

    public function adminLogout(Request $request)
    {
        auth()->guard('admin')->logout();
        Session::flush();
        Session::put('success', 'You are logout sucessfully');
        return redirect(route('admin.login'));
    }
}
