<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\LoanEnquiries;
use \Yajra\Datatables\Datatables;
use App\Models\User;

class LoanController extends Controller
{
    public function getLoans(Request $request)
    {
        if ($request->ajax()) {
            $data = LoanEnquiries::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
               
                ->addColumn('customer_name', function ($data) {
                    return  '<span class="service-name">' . $data->name . '</span>';
                })
                ->addColumn('mobile', function ($data) {
                    return $data->mobile_number;
                })
                ->addColumn('district', function ($data) {
                    return $data->district;
                })
                ->addColumn('service', function ($data) {
                    return  $data->service;
                })
               
                ->addColumn('employee', function ($data) {
                    if ($data->employee_id) {
                       $slug= User::where('employeeID', $data->employee_id)->pluck('slug')->first();
                        return '<a href="' . route('admin.view-agent', ['slug' => $slug]) . '"  target="_blank" >'.$data->employee_id.'</a>';
                    } else {
                        return NULL;
                    }
                })
                ->addColumn('status', function ($data) {
                   
                    return  '
                    
<div class="dropdown show">
  <a class="btn btn-primary dropdown-toggle" style="color:#fff;font-size: 13px;"  title="Change Booking Status" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
    ' . $data->status . '
  </a>

  <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
   <a class="dropdown-item badge badge-secondary" data-id="' . $data->id . '" data-value="Processing" id="leadStatus" href="#" style="color:#fff;font-size: 13px;">Processing</a>
    <a class="dropdown-item badge badge-secondary" data-id="' . $data->id . '" data-value="Approved" id="leadStatus" href="#" style="color:#fff;font-size: 13px;">Approved</a>
    <a class="dropdown-item badge badge-secondary" data-id="' . $data->id . '" data-value="Completed" id="leadStatus" href="#" style="color:#fff;font-size: 13px;">Completed</a>
    <a class="dropdown-item badge badge-secondary" data-id="' . $data->id . '" data-value="Declined" id="leadStatus" href="#" style="color:#fff;font-size: 13px;">Declined</a>
    </div>
</div>';
                })
                ->addColumn('export_status', function ($data) {
                    return  $data->status;
                })
                ->addColumn('date', function ($data) {
                    return  $data->created_at;
                })
                ->escapeColumns([])

                ->make(true);
        }
    }


    public function changeLoanStatus(Request $request)
    {
        $res = LoanEnquiries::where('id', $request->id)
            ->update(['status' => $request->status]);
        if ($res == 1) {
            return response()->json(['message' => 'Update Success', 'status' => true], 200);
        } else {
            return response()->json(['message' => 'Something went wrong', 'status' => false], 500);
        }
    }
}
