<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Exports\LeadsExport;
use App\Imports\HotLeadsImport;
use Maatwebsite\Excel\Facades\Excel;
use \Yajra\Datatables\Datatables;
use App\Models\HotLeads;
use App\Models\User;
use App\Models\CarDetails;
use App\Models\DataGeneration;

class HotLeadsController extends Controller
{
    public function index(Request $request)
    {
        return view('admin.hot-leads');
    }
    public function export()
    {
        return Excel::download(new LeadsExport, 'Leads.xlsx');
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function import()
    {
        Excel::import(new HotLeadsImport, request()->file('file'));

        return back();
    }

    public function getLeads(Request $request)
    {
        if ($request->ajax()) {
            //           $start = request()->get('start', 0);
            //  $length = request()->get('length', 50); // Default 50 records per page

            $data =    HotLeads::whereBetween('created_at', [date('Y-m-d 00:00:00', strtotime($request->from)), date('Y-m-d 23:59:59', strtotime($request->to))])
                //  ->where('status',$request->status)
                ->orderBy('id', 'DESC')
                //   ->skip($start)
                //   ->take($length)
                ->get();
            if ($request->filled('status')) {
                $data = $data->where('status', $request->status);
            }
            if ($request->filled('agent_phone')) {

                $agent = User::where('mobile_number', $request->agent_phone)->first();

                if ($agent != null) {
                    $data = $data->where('agent_id', $agent->id);
                }
            }
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '<a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('customer_name', function ($data) {
                    return  '<span class="service-name">' . $data->customer_name . '</span>';
                })
                ->addColumn('product', function ($data) {
                    return $data->product;
                })
                ->addColumn('source', function ($data) {
                    return $data->source;
                })
                ->addColumn('contact_number', function ($data) {
                    return  $data->contact_number;
                })
                ->addColumn('agent_id', function ($data) {
                    if ($data->agent) {
                        return $data->agent->name;
                    } else {
                        return NULL;
                    }
                })
                ->addColumn('status', function ($data) {

                    return  '
                    
<div class="dropdown show">
  <a class="btn btn-primary dropdown-toggle" style="color:#fff;font-size: 13px;"  title="Change Booking Status" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
    ' . $data->status . '
  </a>

  <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
   <a class="dropdown-item badge badge-secondary" data-id="' . $data->id . '" data-value="PENDING" id="leadStatus" href="#" style="color:#fff;font-size: 13px;">PENDING</a>
    <a class="dropdown-item badge badge-secondary" data-id="' . $data->id . '" data-value="RING NOT RESPOND" id="leadStatus" href="#" style="color:#fff;font-size: 13px;">RING NOT RESPOND</a>
    <a class="dropdown-item badge badge-secondary" data-id="' . $data->id . '" data-value="OUT OF COVERAGE AREA" id="leadStatus" href="#" style="color:#fff;font-size: 13px;">OUT OF COVERAGE AREA</a>
    <a class="dropdown-item badge badge-secondary" data-id="' . $data->id . '" data-value="SWITCH OFF" id="leadStatus" href="#" style="color:#fff;font-size: 13px;">SWITCH OFF</a>
   <a class="dropdown-item badge badge-secondary" data-id="' . $data->id . '" data-value="CALL BACK" id="leadStatus" href="#" style="color:#fff;font-size: 13px;">CALL BACK</a>
    <a class="dropdown-item badge badge-secondary" data-id="' . $data->id . '" data-value="BUSY" id="leadStatus" href="#" style="color:#fff;font-size: 13px;">BUSY</a>
    <a class="dropdown-item badge badge-secondary" data-id="' . $data->id . '" data-value="INTERESTED" id="leadStatus" href="#" style="color:#fff;font-size: 13px;">INTERESTED</a>
    <a class="dropdown-item badge badge-secondary" data-id="' . $data->id . '" data-value="NOT INTERESTED" id="leadStatus" href="#" style="color:#fff;font-size: 13px;">NOT INTERESTED</a>
     <a class="dropdown-item badge badge-secondary" data-id="' . $data->id . '" data-value="SALE CLOSED" id="leadStatus" href="#" style="color:#fff;font-size: 13px;">SALE CLOSED</a>
    <a class="dropdown-item badge badge-secondary" data-id="' . $data->id . '" data-value="CRITERIA NOT MET" id="leadStatus" href="#" style="color:#fff;font-size: 13px;">CRITERIA NOT MET</a>
    </div>
</div>';
                })
                ->addColumn('export_status', function ($data) {
                    return  $data->status;
                })
                ->addColumn('product_selected', function ($data) {
                    return $data->product_selected;
                })
                ->addColumn('cibil_issue', function ($data) {
                    return $data->cibil_issue;
                })
                ->addColumn('salaried_or_selfemployed', function ($data) {
                    return $data->salaried_or_selfemployed;
                })
                ->addColumn('monthly_income', function ($data) {
                    return $data->monthly_income;
                })
                ->addColumn('district', function ($data) {
                    return $data->district;
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function deleteLeads(Request $request)
    {
        $res = HotLeads::where('id', $request->id)->delete();
        return $res;
    }
    public function deletecardetails(Request $request)
    {
        $res = CarDetails::where('id', $request->id)->delete();
        return $res;
    }
    public function changeLeadStatus(Request $request)
    {
        $res = HotLeads::where('id', $request->id)
            ->update(['status' => $request->status]);
        if ($res == 1) {
            return response()->json(['message' => 'Update Success', 'status' => true], 200);
        } else {
            return response()->json(['message' => 'Something went wrong', 'status' => false], 500);
        }
    }

    public function search(Request $request)
    {

        $query = $request->input('query');

        $agents = User::where('status', 1)
            ->where(function ($q) use ($query) {
                $q->where('name', 'like', "%$query%")
                    ->orWhere('mobile_number', 'like', "%$query%");
            })
            ->select('id', 'name', 'mobile_number')
            ->limit(10)
            ->get();

        return response()->json($agents);
    }


    public function updateHotLead(Request $request)
    {
        // $request->validate([
        //     'agent_id' => 'required|exists:users,id',
        // ]);
         $res =  User::where('id', $request->agent_id)->update([
            'hot_leads' => $request->status,
        ]);
      
        if ($res == 1) {
            return redirect()->back()->with('success', 'Hot lead updated successfully!');
        } else {
            return redirect()->back()->with('error', 'Something went wrong');
        }
    }
}
