<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Admin;
use DB;


class WebNotification extends Controller
{
    public function saveToken(Request $request)
    {
        //we are inserting a dummy user with valid token. 

        Admin::where('id', 1)
            ->update([
                'device_token' => $request->token
            ]);
        return response()->json(['success' => true, 'message' => 'token saved successfully.']);
    }

    /**
     * send push notifications to user
     */
    public function sendNotification(Request $request)
    {
        if ($request->isMethod('post')) {
            $rules = [
                'title' => 'required',
                'message' => 'required',
            ];

            $this->validate($request, $rules);

            $firebaseToken = Admin::whereNotNull('device_token')->pluck('device_token')->all();
            $data = [
                "registration_ids" => $firebaseToken,
                "notification" => [
                    "title" => $request->title,
                    "body" => $request->message,
                ]
            ];
            $SERVER_API_KEY = env('FCM_SERVER_KEY');

            $dataString = json_encode($data);
            $headers = [
                'Authorization: key=' . $SERVER_API_KEY,
                'Content-Type: application/json',
            ];

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);

            $response = curl_exec($ch);
            curl_close($ch);
            return back()->with('response', $response);
        }

        return view('home');
    }
}
