<?php

namespace App\Http\Controllers\frontendAPI;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ServiceBooking;
use App\Models\User;
use App\Models\Post;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Intervention\Image\Facades\Image;
use PDF;

class UserController extends Controller
{
    public function dashboard(Request $request)
    {
       
        $date = date('Y/m/d', strtotime($request->end_date . " +1 days"));
        $data = ServiceBooking::where('agent_id', auth()->user()->id)->where('status', $request->status)->whereBetween('created_at', [$request->start_date, $date])->with('note')->with('service')->get();

        $data = collect($data->toArray())->map(function ($item) {
            if($item['service'])
            $item['service']['image'] = asset('uploads/services/') . '/' . $item['service']['image'];
            else
            $item['service']['image']=asset('assets/images/dashboard-logo.png');
            
            return $item;
        });
       
        if (count($data) > 0) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data->toArray(),
                    'message' => "Success"
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data->toArray(),
                    'message' => "No Data Available"
                ),
                200
            );
        }
    }
    public function editAgent(Request $request)
    {
        $user = User::where('id', auth()->user()->id)->first();
        $data = [
            'employeeID' => $user->employeeID,
            'name' => $user->name,
            'mobile_number' => $user->mobile_number,
            'email' => $user->email,
            'designation' => $user->designation,
            'image' => asset('uploads/agent/' . $user->image),
            'total_commission' => $user->total_commission
        ];
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => "No data Available"
                ),
                200
            );
        }
    }

    public function updateAgent(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required',
            'mobile_number' => 'required|numeric|digits:10',
            // 'image' => 'mimes:jpg,jpeg,png,gif,svg,webp|max:2048'
        ]);


        // ******** Image uploade start ********
        if ($request->hasFile('image')) {
            $image = $request->image;
            $rand = rand(100, 999);
            $input['file'] = time() . $rand . '.' . $image->getClientOriginalExtension();
            $imgname = $input['file'];
            $destinationPath = public_path('uploads/agent');

            $imgFile = Image::make($image->getRealPath());
            $res = User::where('id', auth()->user()->id)
                ->update([
                    'image' => $input['file']
                ]);

            $img = Image::make($image)
                // ->resize(870, 400)
                ->save($destinationPath . '/' . $input['file']);
            $img->save();
        }
        // ******** Image uploade end ********

        $res = User::where('id', auth()->user()->id)
            ->update([
                'name' => $request->name,
                'slug' => SlugService::createSlug(User::class, 'slug', $request->name),
                'email' => $request->email,
                'mobile_number' => $request->mobile_number
            ]);
        if ($res == 1) {
            return response()->json(
                array(
                    'status' => True,
                    'message' => "Profile updated successfully"
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'message' => "Opps. Something wrong.. Please tryagain"
                ),
                200
            );
        }
    }

    public function generateOfferLetter()
    {
        $data = User::where('id', auth()->user()->id)->first();
        $pdf = PDF::loadView('pdf.offer-letter', ['data' => $data]);

        return $pdf->download('OFFER-LETTER.pdf');
    }

    public function generateIDcard()
    {
        $data = User::where('id', auth()->user()->id)->first();

        $pdf = PDF::loadView('pdf.IDcard', ['data' => $data]);
        return $pdf->download('ID-card');
    }

    public function generateVistingcard()
    {
        $data = User::where('id', auth()->user()->id)->first();

        $pdf = PDF::loadView('pdf.visiting-card', ['data' => $data]);
        return $pdf->download('visiting-card');
    }


    public function post(Request $request)
    {
        $array = Post::orderBy('id', 'Desc')->get();
        if ($request->service_id) {
            $array = Post::where('service_id', $request->service_id)->get();
        }
        $data = collect($array->toArray())->map(function ($item) {
            $item['image'] = asset('uploads/post/') . '/' . $item['image'];
            return $item;
        });

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }
    
      public function addgpay(Request $request)
    {
        $request->validate([
            'gpay_name' => 'required',
            'gpay_number' => 'required|numeric|digits:10',
            // 'image' => 'mimes:jpg,jpeg,png,gif,svg,webp|max:2048'
        ]);


    
        $res = User::where('id', auth()->user()->id)
            ->update([
                'gpay_number' => $request->gpay_number,
                 'gpay_name' => $request->gpay_name
            ]);
        if ($res == 1) {
            return response()->json(
                array(
                    'status' => True,
                    'message' => "Profile updated successfully"
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'message' => "Opps. Something wrong.. Please tryagain"
                ),
                200
            );
        }
    }
    
      public function getgpay(Request $request)
    {
        $data = User::select('gpay_name','gpay_number')->where('id', auth()->user()->id)->first();
       
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => "No data Available"
                ),
                200
            );
        }
    }


}
