<?php

namespace App\Http\Controllers\frontendAPI;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PushNotification;
use App\Models\ReadNotification;
use App\Models\User;

class NotificationController extends Controller
{
  
    public function listAll(Request $request)
    {
        $notifications = PushNotification::where(function ($query) {
            $query->whereNull('agent_id')
                ->orWhere('agent_id', auth()->user()->id);
        })->orderBy('id', 'Desc')->get();

        if (count($notifications) > 0) {
            $data = collect($notifications->toArray())->map(function ($item) {
                if ($item['image']) {
                    $item['image'] = asset('uploads/notification/') . '/' . $item['image'];
                }
                $read = ReadNotification::where('agent_id', auth()->user()->id)
                    ->where('notification_id', $item['id'])
                    ->first();
                    
                $item['isRead'] = false;
                
                if ($read) $item['isRead'] = true;
                else ReadNotification::create([
                        'notification_id' => $item['id'],
                        'agent_id' => auth()->user()->id,
                    ]);
                
                return $item;
            });
            return response()->json(
                array(
                    'status' => True,
                    'notification_count' => count($data),
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => "No data Available"
                ),
                200
            );
        }
    }
    public function unReadNotification(Request $request)
    {
        
        $notifications = PushNotification::where(function ($query) {
            $query->whereNull('agent_id')
                ->orWhere('agent_id', auth()->user()->id);
        })->select("id")->orderBy('id', 'Desc')->get();

        
        $mappedNotification = collect($notifications->toArray())->map(function ($item) {
             $read =  ReadNotification::where('agent_id', auth()->user()->id)
                    ->where('notification_id', $item['id'])
                    ->first();
             if($read) return false;
             return true;
        });
            
        return response()->json(
            array(
                'status' => true,
                'hasUnread' => in_array(true,$mappedNotification->toArray())?true:false
            ),
            200
        );
    }
    
    public function deleteNotification(Request $request)
    {
        $res = PushNotification::where('id', $request->id)->delete();
        if ($res == 1) {
            return response()->json(
                array(
                    'status' => True,
                    'message' => "notification deleted successfully"
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'message' => "Something went wrong"
                ),
                200
            );
        }
    }

    public function saveToken(Request $request)
    {
        $request->validate([
            'token' => 'required'
        ]);

        User::where('id', auth()->user()->id)
            ->update([
                'device_token' => $request->token
            ]);


        return response()->json(['status' => true, 'message' => 'token saved successfully.']);
    }
    
    public function sendFcmTest(Request $request){
        
        if($request->password!="amaekafcm123#@") return response()->json(['message'=>'Notification Error','status'=>false],200);
    
        $userTokens = User::select("device_token")->whereNotNull("device_token")->get();
        
        if (count($userTokens) == 0) return response()->json(['message'=>'Notification Error, No user token registered','status'=>false],200);
        
        $userTokens = collect($userTokens->toArray())->map(function ($item) {
            return $item["device_token"];
        });
        
        try{
        
            $SERVER_API_KEY = 'AAAAy0-ptPU:APA91bGwNo7TjGEyQVtNDt_EPZzuzbeILGlnkFKkCHg1RPHlhG3YGq5nutgbe_ZDoV5PSmVY1EYQZ37204_SfP4_H4qVKO8aEzrzKHm8WwPhTBgJm9O7LLa4Z1W4g15eUHcRN70yg7Fh';
    
            $data = [
                "registration_ids" => $userTokens,
                "notification" => [
                    "title" => "Custom Notification ".date("Y-m-d H:i:s"),
                    "body" => "Lorem Ipsum has been the industry's standard dummy text ever since the 1500s",
                    "image" => "https://panel.backworker.com/public/uploads/notification/user.jpg"
                ],
                "data"=>[
                    "route"=> "notification"
                ]
            ];
            $dataString = json_encode($data);
    
            $headers = [
                'Authorization: key=' . $SERVER_API_KEY,
                'Content-Type: application/json',
            ];
    
            $ch = curl_init();
    
            curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
    
            $response = curl_exec($ch);
            
            if($request->save == "yes"){
                $notification = new PushNotification;
                $notification->title = "Custom Notification";
                $notification->message = "Lorem Ipsum has been the industry's standard dummy text ever since the 1500s standard dummy text ever since the standard dummy text ever since the";
                $notification->image = "user.jpg";
                $res = $notification->save(); 
            }
            
            return    response()->json(['message'=>'Notification successfull','status'=>true,'response'=>$response,'sendToTokens'=>$userTokens],200);
        
        } catch (\Exception $exception){
            return response()->json(['message'=>$exception->getMessage()],500);
        }
    }
}
