<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Exports\LeadsExport;
use App\Imports\LeadsImport;
use Maatwebsite\Excel\Facades\Excel;
use \Yajra\Datatables\Datatables;
use App\Models\Leads;
use App\Models\User;
use App\Models\CarDetails;
use App\Models\DataGeneration;

class LeadsController extends Controller
{
    public function index(Request $request)
    {
        return view('admin.lead');
    }
    public function export()
    {
        return Excel::download(new LeadsExport, 'Leads.xlsx');
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function import()
    {
        Excel::import(new LeadsImport, request()->file('file'));

        return back();
    }

    public function getLeads(Request $request)
    {
        if ($request->ajax()) {
//           $start = request()->get('start', 0);
//  $length = request()->get('length', 50); // Default 50 records per page

            $data =    Leads::whereBetween('created_at',[date('Y-m-d 00:00:00',strtotime($request->from)),date('Y-m-d 23:59:59',strtotime($request->to))])
          ->where('status',$request->status)
          ->orderBy('id', 'DESC')
        //   ->skip($start)
        //   ->take($length)
          ->get();
           
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '<a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('customer_name', function ($data) {
                    return  '<span class="service-name">' . $data->customer_name . '</span>';
                })
                ->addColumn('product', function ($data) {
                    return $data->product;
                })
                ->addColumn('source', function ($data) {
                    return $data->source;
                })
                ->addColumn('contact_number', function ($data) {
                    return  $data->contact_number;
                })
                ->addColumn('agent_id', function ($data) {
                    if ($data->agent) {
                        return $data->agent->name;
                    } else {
                        return NULL;
                    }
                })
                ->addColumn('status', function ($data) {
                   
                    return  '
                    
<div class="dropdown show">
  <a class="btn btn-primary dropdown-toggle" style="color:#fff;font-size: 13px;"  title="Change Booking Status" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
    ' . $data->status . '
  </a>

  <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
   <a class="dropdown-item badge badge-secondary" data-id="' . $data->id . '" data-value="PENDING" id="leadStatus" href="#" style="color:#fff;font-size: 13px;">PENDING</a>
    <a class="dropdown-item badge badge-secondary" data-id="' . $data->id . '" data-value="RING NOT RESPOND" id="leadStatus" href="#" style="color:#fff;font-size: 13px;">RING NOT RESPOND</a>
    <a class="dropdown-item badge badge-secondary" data-id="' . $data->id . '" data-value="OUT OF COVERAGE AREA" id="leadStatus" href="#" style="color:#fff;font-size: 13px;">OUT OF COVERAGE AREA</a>
    <a class="dropdown-item badge badge-secondary" data-id="' . $data->id . '" data-value="SWITCH OFF" id="leadStatus" href="#" style="color:#fff;font-size: 13px;">SWITCH OFF</a>
   <a class="dropdown-item badge badge-secondary" data-id="' . $data->id . '" data-value="CALL BACK" id="leadStatus" href="#" style="color:#fff;font-size: 13px;">CALL BACK</a>
    <a class="dropdown-item badge badge-secondary" data-id="' . $data->id . '" data-value="BUSY" id="leadStatus" href="#" style="color:#fff;font-size: 13px;">BUSY</a>
    <a class="dropdown-item badge badge-secondary" data-id="' . $data->id . '" data-value="INTERESTED" id="leadStatus" href="#" style="color:#fff;font-size: 13px;">INTERESTED</a>
    <a class="dropdown-item badge badge-secondary" data-id="' . $data->id . '" data-value="NOT INTERESTED" id="leadStatus" href="#" style="color:#fff;font-size: 13px;">NOT INTERESTED</a>
     <a class="dropdown-item badge badge-secondary" data-id="' . $data->id . '" data-value="SALE CLOSED" id="leadStatus" href="#" style="color:#fff;font-size: 13px;">SALE CLOSED</a>
    <a class="dropdown-item badge badge-secondary" data-id="' . $data->id . '" data-value="CRITERIA NOT MET" id="leadStatus" href="#" style="color:#fff;font-size: 13px;">CRITERIA NOT MET</a>
    </div>
</div>';
                })
                ->addColumn('export_status', function ($data) {
                    return  $data->status;
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function deleteLeads(Request $request)
    {
        $res = Leads::where('id', $request->id)->delete();
        return $res;
    }
   public function deletecardetails(Request $request)
    {
        $res = CarDetails::where('id', $request->id)->delete();
        return $res;
    }
    public function changeLeadStatus(Request $request)
    {
        $res = Leads::where('id', $request->id)
            ->update(['status' => $request->status]);
        if ($res == 1) {
            return response()->json(['message' => 'Update Success', 'status' => true], 200);
        } else {
            return response()->json(['message' => 'Something went wrong', 'status' => false], 500);
        }
    }
    
       public function getDataGeration(Request $request)
    {
        if ($request->ajax()) {
            $data = DataGeneration::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '<a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('customer_name', function ($data) {
                    return  '<span class="service-name">' . $data->full_name . '</span>';
                })
                ->addColumn('mobile_number', function ($data) {
                    return  $data->mobile_number;
                })
                ->addColumn('company_name', function ($data) {
                    return $data->company_name;
                })
                ->addColumn('approximate_salary', function ($data) {
                    return $data->approximate_salary;
                })
                ->addColumn('location', function ($data) {
                    return  $data->Location;
                })
                ->addColumn('agent', function ($data) {
                    if ($data->agent) {
                        return $data->agent->name;
                    } else {
                        return NULL;
                    }
                })
                ->addColumn('date', function ($data) {
                    return date("d M Y", strtotime($data->created_at));
                })
                ->escapeColumns([])

                ->make(true);
        }
    }
    
       public function getcardetails(Request $request)
    {
        if ($request->ajax()) {
            $data = CarDetails::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '<a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('customer_name', function ($data) {
                    return  '<span class="service-name">' . $data->full_name . '</span>';
                })
                ->addColumn('mobile_number', function ($data) {
                    return  $data->mobile_number;
                })
                ->addColumn('company_name', function ($data) {
                    return $data->car_brand;
                })
                ->addColumn('approximate_salary', function ($data) {
                    return $data->car_model;
                })
                ->addColumn('location', function ($data) {
                    return  $data->manufacturing_year;
                })
                ->addColumn('agent', function ($data) {
                    $user=User::where('id',$data->agent_id)->pluck('name')->first();
                    if ($user) {
                        return $user;
                    } else {
                        return NULL;
                    }
                })
                ->addColumn('date', function ($data) {
                    return date("d M Y", strtotime($data->created_at));
                })
                ->escapeColumns([])

                ->make(true);
        }
    }
}
