<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\LoanEnquiries;
use Illuminate\Support\Facades\Response;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use App\Models\PushNotification;
use App\Models\User;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Storage;
use PDF;
use Illuminate\Support\Facades\File;

class QRCodeController extends Controller
{
    public function generateQRCode(Request $request)
    {

     $employeeId = auth()->user()->employeeID;
//   $employeeId = 'BW613675';
        // Generate a URL with the employee ID
     $url = route('enquiries', ['employee_id' =>  $employeeId]);

     $filePath = public_path('qrcodes_' .$employeeId.'.svg');
     
        // Generate the QR code with the URL
    $qrCode = QrCode::size(200)->generate($url,$filePath);
  
     // return view('qrcode', compact('qrCode'));
     $pdf = PDF::loadView('qrcode', compact('filePath'));
     return $pdf->download('qrcode');

     // return response($qrCode, 200);
    //  ->header('Content-Type', 'image/png');
      
    }

    public function downloadQRCode(Request $request)
    {
       
        // Retrieve the logged-in employee's ID
    $employeeId = auth()->user()->employeeID;
   // $employeeId = 'BW613675';
        // Generate a URL with the employee ID
     $url = route('enquiries', ['employee_id' =>  $employeeId]);

      // Specify the storage path
    // $filePath = storage_path('app/public/qrcode_ '.$employeeId.'.svg');

    //     // Generate the QR code with the URL
    // $qrCode = QrCode::size(300)->generate($url, $filePath);
   
    
        // Return the QR code as a response or view
   //   return  response()->download($url);
   return response()->json(
    array(
        'status' => True,
        'url' => $url
    ),
    200
);
      
    }

    public function saveEnquiries(Request $request)
    {
        $res = LoanEnquiries::insert([
            'name' => $request->name,
            'mobile_number' => $request->phone,
            'service' => $request->service,
            'district' => $request->district,
            'employee_id' => $request->employee_id,
        ]);

        $firebaseToken = User::where('employeeID',$request->employee_id)->pluck('device_token')->first();

        $notification = new PushNotification;
        $notification->title =  "New Loan Application Submitted by ".$request->name;
        $notification->message = $request->name . " submit a loan application for ".$request->service;
        $notification->agent_id = User::where('employeeID',$request->employee_id)->pluck('id')->first();
        $res = $notification->save(); 

            $data = [
               'token' => $firebaseToken,
                "notification" => [
                    "title" => "New Loan Application Submitted by ".$request->name,
                    "body" => $request->name . " submit a loan application for ".$request->service,
                ]
            ];
            $SERVER_API_KEY = env('FCM_SERVER_KEY');

            $dataString = json_encode($data);
            $headers = [
                'Authorization: key=' . $SERVER_API_KEY,
                'Content-Type: application/json',
            ];

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);

            $response = curl_exec($ch);
            curl_close($ch);
        if ($res == 1) {
           // return view("success");
         return redirect()->route('success');
        } else {
            return back()->with('error', "Something Wrong");
        }
    }
    public function getLoanEnquiries(Request $request)
    {
        $res = LoanEnquiries::where('employee_id' , auth()->user()->employeeID)->get();

        if (count($res)>0) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $res,
                    'message' => "Success"
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => [],
                    'message' => "No Data Available"
                ),
                200
            );
        }
    }
    public function enquiries(Request $request)
    {
        return view('enquires', ['employee_id' => $request->employee_id]);
    }

    public function changeLoanEnquiriesStatus(Request $request)
    {
        $res = LoanEnquiries::where('id' , $request->loan_id)->update(['status'=>$request->status]);

        if ($res==1) {
            return response()->json(
                array(
                    'status' => True,
                    'message' => "Status Updated Successfully"
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'message' => "Something went wrong"
                ),
                200
            );
        }
    }

    public function saveqrcodeimage(Request $request)
    {

        $request->validate([
            'image' => 'required|mimes:png'
        ]);

        try {

            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                $image = $request->image;
                $rand = rand(100, 999);
                $input['file'] = 'qrcodeposter.' . $image->getClientOriginalExtension();

                $destinationPath = public_path('assets/images/');

                $imgFile = Image::make($image->getRealPath());
                $img = Image::make($image)
                    // ->resize(870, 400)
                    ->save($destinationPath . '/' . $input['file']);
                $img->save();
            }
            // ******** Image uploade end ********
            // $banner = new Banner;
            // $banner->service_id = $request->service;
            // $banner->image = $input['file'];
            // $res =  $banner->save();
            // if ($res == 1) {

                return redirect()->back()->with('success', "Template Added Successfully");
            // } else {
            //     return back()->with('error', "Something Wrong");
            // }
        } catch (QueryException $e) {

            return back()->with('error', $e->getMessage());
        }
    }
}
