<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\StadiumController;
use App\Http\Controllers\TeamController;
use App\Http\Controllers\BannerController;
use App\Http\Controllers\EventBlockController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\StadiumBlockController;
use App\Http\Controllers\SubCategoryController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\GiftOffersController;
use App\Http\Controllers\CouponController;
use App\Http\Controllers\HomeSectionController;
use App\Http\Controllers\OrderController;

Route::get('/', function () {
    return view('auth.login');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // Country routes
    Route::get('/country', function () {
        return view('admin.country');
    })->name('country.index');

    // Settings Controller routes
    Route::controller(SettingsController::class)->group(function () {
        Route::get('/get/country', 'getCountry')->name('get-country');
        Route::post('/add/country', 'addCountry')->name('add-country');
        Route::delete('/delete-country/{id}', 'destroy')->name('delete-country');
        Route::put('/update-country/{id}', 'update')->name('update-country');

        // Country routes

    });



    // category routes
    Route::get('/category', function () {
        return view('admin.category');
    })->name('category.index');

    // Settings Controller routes
    Route::controller(CategoryController::class)->group(function () {
        Route::get('/get/category', 'getcategory')->name('get-category');
        Route::post('/add/category', 'addcategory')->name('add-category');
        Route::delete('/delete-category/{id}', 'destroy')->name('delete-category');
        Route::put('/update-category/{id}', 'update')->name('update-category');
    });
    // category routes


    // subcategory start 
    // SubCategory Routes
    Route::get('/subcategory', function () {
        return view('admin.subcategory');
    })->name('subcategory');

    Route::get('/get-subcategory', [SubCategoryController::class, 'getSubCategory'])->name('get-subcategory');
    Route::post('/add-subcategory', [SubCategoryController::class, 'addSubCategory'])->name('add-subcategory');
    Route::post('/update-subcategory/{id}', [SubCategoryController::class, 'update'])->name('update-subcategory');
    Route::delete('/delete-subcategory/{id}', [SubCategoryController::class, 'destroy'])->name('delete-subcategory');
    Route::post('/toggle-subcategory-status/{id}', [SubCategoryController::class, 'toggleStatus'])->name('toggle-subcategory-status');

    // subcategory end

    // routes/web.php

    //products start
        Route::get('/add-product', function () {
        return view('admin.add-product');
    })->name('add-product');
    Route::get('product-list', [ProductController::class, 'index'])->name('products');
    Route::get('get-product-list', [ProductController::class, 'getProducts'])->name('get-products');
    Route::post('product-store', [ProductController::class, 'store'])->name('product.store');
    //Route::get('get-subcategories/{id}', [ProductController::class, 'getSubcategories']);
    Route::get('get-subcategories/{category_id}', function ($category_id) {
        return App\Models\SubCategory::where('category_id', $category_id)->get(['id', 'name']);
    });
    Route::get('get-product/{id}', [ProductController::class, 'show'])->name('edit-product');
    Route::post('update-product/{id}', [ProductController::class, 'update'])->name('update-product');
    Route::delete('delete-product/{id}', [ProductController::class, 'destroy']);
    Route::post('/product-trending/{id}', [ProductController::class, 'updateTrending'])->name('product.trending');


    // products end
    // ******** tickets ******
    // Teams
    Route::get('/teams', [TeamController::class, 'index'])->name('teams');
    Route::post('/add-team', [TeamController::class, 'store'])->name('add-team');
    Route::get('/get-teams', [TeamController::class, 'getTeams'])->name('get-teams');
    Route::put('/update-team/{id}', [TeamController::class, 'update']);
    Route::delete('/delete-team/{id}', [TeamController::class, 'destroy']);

    // Stadiums
    Route::get('/stadiums', [StadiumController::class, 'index'])->name('stadiums');
    Route::get('/get-stadiums', [StadiumController::class, 'getStadiums'])->name('get-stadiums');
    Route::post('/add-stadium', [StadiumController::class, 'store'])->name('add-stadium');
    Route::post('/update-stadium/{id}', [StadiumController::class, 'update'])->name('update-stadium');
    Route::delete('/delete-stadium/{id}', [StadiumController::class, 'destroy'])->name('delete-stadium');

    //stadium block
    Route::get('/stadium-blocks', function () {
        return view('admin.stadium_blocks');
    })->name('stadium-blocks');
    Route::get('/get-blocks', [StadiumBlockController::class, 'getBlocks'])->name('get-blocks');
    Route::post('/add-block', [StadiumBlockController::class, 'store'])->name('add-block');
    Route::post('/update-block/{id}', [StadiumBlockController::class, 'update'])->name('update-block');
    Route::delete('/delete-block/{id}', [StadiumBlockController::class, 'destroy'])->name('delete-block');


    // Events
    Route::get('/events', fn() => view('admin.events'))->name('events');
    Route::get('/get-events', [EventController::class, 'getEvents'])->name('get-events');
    Route::post('/add-event', [EventController::class, 'store'])->name('add-event');
    Route::post('/update-event/{id}', [EventController::class, 'updateEvent'])->name('update-event');
    Route::delete('/delete-event/{id}', [EventController::class, 'destroy'])->name('delete-event');
    Route::get('/get-event/{id}', [EventController::class, 'editEvent'])->name('edit-event');

    //event block
    Route::get('/event-blocks', [EventBlockController::class, 'index'])->name('event-blocks');
    Route::get('/get-event-blocks', [EventBlockController::class, 'getBlocks'])->name('get-event-blocks');
    Route::post('/add-event-block', [EventBlockController::class, 'store'])->name('add-event-block');
    Route::get('/get-event-block/{id}', [EventBlockController::class, 'edit'])->name('get-event-block');
    Route::post('/update-event-block/{id}', [EventBlockController::class, 'update'])->name('update-event-block');
    Route::delete('/delete-event-block/{id}', [EventBlockController::class, 'destroy'])->name('delete-event-block');
    // ***********tickets ends ***********

    // banner start
    Route::get('banner', function () {
        return view('admin.banner');
    })->name('banner');
    Route::get('get-banner', [BannerController::class, 'getBanner'])->name('get-banner');
    Route::post('add-banner', [BannerController::class, 'addBanner'])->name('add-banner');
    Route::delete('delete-banner/{id}', [BannerController::class, 'destroy']);
    Route::put('update-banner/{id}', [BannerController::class, 'update']);
    Route::get('/get-products/{category_id}', [ProductController::class, 'getProductsByCategory']);
    Route::post('banner/status/{id}', [BannerController::class, 'changeStatus'])->name('banner.status');

    // banner end

    // gift offers



    Route::get('gift-offers', function () {
        return view('admin.giftoffers');
    })->name('gift-offers');

    Route::get('get-offers', [GiftOffersController::class, 'getOffers'])->name('get-offers');
    Route::post('add-offer', [GiftOffersController::class, 'addOffer'])->name('add-offer');
    Route::delete('delete-offer/{id}', [GiftOffersController::class, 'destroy']);
    Route::post('update-offer/{id}', [GiftOffersController::class, 'update']);
    Route::post('offer/status/{id}', [GiftOffersController::class, 'changeStatus']);

    Route::get('/gift-offer/edit/{id}', [GiftOffersController::class, 'edit'])->name('gift.offer.edit');
    Route::post('/gift-offer/update/{id}', [GiftOffersController::class, 'update'])->name('gift.offer.update');

    // gift offers end

    //coupon
    Route::get('/coupons', [CouponController::class, 'index'])->name('coupons');
    Route::get('/get-coupons', [CouponController::class, 'getCoupons'])->name('get-coupons');
    Route::post('/add-coupon', [CouponController::class, 'store'])->name('add-coupon');
    Route::get('/coupon/edit/{id}', [CouponController::class, 'edit']);
    Route::post('/coupon/update/{id}', [CouponController::class, 'update']);
    Route::delete('/delete-coupon/{id}', [CouponController::class, 'destroy']);
    Route::post('/coupon/status/{id}', [CouponController::class, 'changeStatus']);

    Route::get('/get-categories/{country_id}', [CouponController::class, 'getCategories']);
    Route::get('/get-products/{category_id}', [CouponController::class, 'getProducts']);


    Route::get('/coupons/{id}/edit', [CouponController::class, 'edit']);
Route::get('/get-countries-list', [CouponController::class, 'getCountries']); // helper route

    // end coupon

    // Home Section
Route::get('/home-sections', [HomeSectionController::class, 'index'])->name('home-sections');
Route::get('/get-home-sections', [HomeSectionController::class, 'list'])->name('get-home-sections');

Route::post('/add-home-section', [HomeSectionController::class, 'store'])->name('add-home-section');
Route::post('/update-home-section/{id}', [HomeSectionController::class, 'update']);
Route::delete('/delete-home-section/{id}', [HomeSectionController::class, 'destroy']);

Route::post('/toggle-home-section-status/{id}', [HomeSectionController::class, 'toggleStatus']);

// order

  Route::get('orders', function () {
        return view('admin.orders');
    })->name('orders');
   Route::get('/get-orders', [OrderController::class, 'getOrders'])->name('get-orders');
    Route::delete('/order/{id}', [OrderController::class, 'deleteOrder'])
     ->name('delete-order');
    Route::get('/order/{orderid}', [OrderController::class, 'getOrder'])->name('get-order');
     Route::get('/order/invoice/{orderid}', [OrderController::class, 'downloadInvoice'])->name('download-invoice');
   Route::post('/admin/orders/status', [OrderController::class, 'updateStatus'])->name('updateStatus');

});

require __DIR__ . '/auth.php';
