<?php
// use Illuminate\Auth\Middleware\Authenticate;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\HomeController;
use App\Http\Controllers\Api\LoginController;
use App\Http\Controllers\Api\CartController;
use App\Http\Controllers\Api\ProductController;
use App\Http\Controllers\Api\OrderController;


// Guest Cart
Route::middleware('api')->group(function () {

    // Public Routes
    Route::post('/send-otp', [LoginController::class, 'sendOtp']);
    Route::post('/create/user', [LoginController::class, 'createuser']);
    Route::post('/verify-otp', [LoginController::class, 'verifyOtp']);

    Route::post('/categories', [HomeController::class, 'categories']);
    Route::post('/icon/subcategories', [HomeController::class, 'iconSubcategories']);
    Route::post('/banner', [HomeController::class, 'bannerList']);
 Route::post('/home/categories', [HomeController::class, 'homeCategories']);

    Route::post('/trending-products', [HomeController::class, 'trendingProducts']);
    Route::post('/home', [HomeController::class, 'home']);
    Route::get('/countries', [HomeController::class, 'index']);
});

// After Login (Secure Routes)
Route::middleware(['api', 'auth:sanctum'])->group(function () {
    Route::post('/order', [OrderController::class, 'placeOrder']);
    Route::post('/order/apply-coupon', [OrderController::class, 'applyCoupon']);
    Route::post('/add-delivery-address', [OrderController::class, 'addDeliveryAddress']);

    Route::get('/my-orders', [OrderController::class, 'myOrders']);

    Route::post('/update-profile', [LoginController::class, 'updateProfile']);


    //===cart=======

    Route::post('cart/add', [CartController::class, 'addToCart']);
    Route::get('cart', [CartController::class, 'getCart']);
    Route::post('cart/update', [CartController::class, 'updateCart']);
    Route::delete('cart/delete/{id}', [CartController::class, 'removeFromCart']);

    // PROFILE
    Route::get('/profile', function () {
        return auth()->user();
    });

    // CATEGORIES
    Route::get('/track-order/{order_id}', [OrderController::class, 'trackOrder']);
    Route::post('/add/review', [OrderController::class, 'storeReview']);

    // LOGOUT
    Route::post('/logout', [LoginController::class, 'logout']);
});
