@extends('admin.layout.template')
@section('title','Home Sections')
@section('content')

<div class="page-content">
    <div class="container-xxl">

        <!-- ADD FORM -->
        <div class="card mb-4">
            <div class="card-header">
                <h5>Add Home Section</h5>
            </div>
            <div class="card-body">

                <form id="addHomeSectionForm">
                    @csrf
                    <div class="row g-3">

                        <div class="col-md-3">
                            <label>Title</label>
                            <input type="text" name="title" class="form-control" required>
                        </div>

                        <div class="col-md-2">
                            <label>Source Type</label>
                            <select name="source_type" id="source_type" class="form-control" required>
                                <option value="">Select</option>
                                <option value="category">Category</option>
                                <option value="subcategory">Sub Category</option>
                                <option value="all_category">All Category</option>
                                <option value="banner">Banner</option>
                                <option value="seasonal_banner">Seasonal Banner</option>
                            </select>
                        </div>

                        <div class="col-md-2">
                            <label>Source</label>
                            <select name="source_id" id="source_id" class="form-control" required></select>
                        </div>

                        <div class="col-md-3">
                            <label>UI Type</label>
                            <select name="ui_type" class="form-control" required>
                                <option value="category_style">Category Style</option>
                                <option value="product_with_cart_style">Product with cart Style</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label>Position</label>
                            <input type="number" name="position" class="form-control" required>
                        </div>
                    </div>
                    <div class="text-end mt-3">
                        <button class="btn btn-success">Save</button>
                    </div>
                </form>

            </div>
        </div>

        <!-- TABLE -->
        <div class="card">
            <div class="card-body table-responsive">
                <table class="table table-bordered text-center">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Title</th>
                            <th>Postion</th>
                            <th>Source</th>
                            <th>UI Type</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>

    </div>
</div>

<!-- EDIT MODAL -->
<div class="modal fade" id="editModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="editHomeSectionForm">
                @csrf
                <input type="hidden" id="edit_id">

                <div class="modal-header">
                    <h5>Edit Home Section</h5>
                </div>

                <div class="modal-body">
                    <input type="text" id="edit_title" name="title" class="form-control mb-2">
                    <input type="number" id="edit_position" name="position" class="form-control mb-2" required>
                    <select id="edit_ui_type" name="ui_type" class="form-control">
                        <option value="category_style">Category Style</option>
                        <option value="product_with_cart_style">Product with cart Style</option>
                    </select>
                </div>

                <div class="modal-footer">
                    <button class="btn btn-success">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    $(function() {

        var categories = @json($categories);
        var subcategories = @json($subcategories);

        function populateSource(type, target) {
            let html = '<option value="">Select</option>';
            let data = type === 'category' ? categories : subcategories;

            data.forEach(d => {
                html += `<option value="${d.id}">${d.name}</option>`;
            });

            $(target).html(html);
        }

        $('#source_type').change(function() {
            let type = $(this).val();

            if (type === 'all_category' || type=='banner'|| type=='seasonal_banner') {
                $('#sourceWrapper').hide();
                $('#source_id').prop('required', false).val('');
                return;
            }

            $('#sourceWrapper').show();
            $('#source_id').prop('required', true);

            populateSource(type, '#source_id');
        });

        // DATATABLE
        var table = $('.table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('get-home-sections') }}",
            columns: [{
                    data: 'DT_RowIndex'
                },
                {
                    data: 'title'
                },
                {
                    data: 'position'
                },
                {
                    data: 'source'
                },
                {
                    data: 'ui_type'
                },
                {
                    data: 'status'
                },
                {
                    data: 'action'
                },
            ]
        });

        // ADD
        $('#addHomeSectionForm').submit(function(e) {
            e.preventDefault();
            $.post("{{ route('add-home-section') }}", $(this).serialize(), function(res) {
                Swal.fire({
                    icon: 'success',
                    title: res.success,
                    timer: 1500,
                    showConfirmButton: false
                });
                table.ajax.reload();
                $('#addHomeSectionForm')[0].reset();
            });
        });

        // EDIT
        $(document).on('click', '.editHomeSection', function() {
            $('#edit_id').val($(this).data('id'));
            $('#edit_title').val($(this).data('title'));
            $('#edit_position').val($(this).data('position'));
            $('#edit_ui_type').val($(this).data('ui_type'));
            $('#editModal').modal('show');
        });

        // UPDATE
        $('#editHomeSectionForm').submit(function(e) {
            e.preventDefault();
            var id = $('#edit_id').val();
            $.post('/update-home-section/' + id, $(this).serialize(), function(res) {
                Swal.fire({
                    icon: 'success',
                    title: res.success,
                    timer: 1500,
                    showConfirmButton: false
                });
                $('#editModal').modal('hide');
                table.ajax.reload();
            });
        });

        // DELETE
        $(document).on('click', '.deleteHomeSection', function() {
            var id = $(this).data('id');
            Swal.fire({
                title: 'Delete?',
                showCancelButton: true
            }).then(r => {
                if (r.isConfirmed) {
                    $.ajax({
                        url: '/delete-home-section/' + id,
                        method: 'DELETE',
                        data: {
                            _token: '{{csrf_token()}}'
                        },
                        success: function(res) {
                            Swal.fire({
                                icon: 'success',
                                title: res.success,
                                timer: 1500,
                                showConfirmButton: false
                            });
                            table.ajax.reload();
                        }
                    });
                }
            });
        });

        // STATUS
        $(document).on('change', '.toggleStatus', function() {
            $.post('/toggle-home-section-status/' + $(this).data('id'), {
                _token: '{{csrf_token()}}'
            });
        });

    });
</script>

@endsection