@extends('admin.layout.template')
@section('title', 'Edit Product')
@section('content')

<div class="page-content">
    <div class="container-xxl">

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title d-flex align-items-center gap-1">
                            <iconify-icon icon="solar:box-bold-duotone" class="text-primary fs-20"></iconify-icon>
                            Edit Product
                        </h4>
                    </div>

                    <div class="card-body">
                        <form id="editProductForm" enctype="multipart/form-data">
                            @csrf
                            <div class="row g-3">

                                <!-- Product Basic Fields -->
                                <div class="col-lg-4">
                                    <label class="form-label">Category</label>
                                    <select name="category_id" id="categorySelect" class="form-control" required>
                                        @foreach(App\Models\Category::all() as $cat)
                                            <option value="{{ $cat->id }}" {{ $product->category_id == $cat->id ? 'selected' : '' }}>
                                                {{ $cat->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-lg-4">
                                    <label class="form-label">Subcategory</label>
                                    <select name="sub_category_id" id="subcategorySelect" class="form-control">
                                        <option value="">Select Subcategory</option>
                                        @foreach(App\Models\SubCategory::where('category_id', $product->category_id)->get() as $subcat)
                                            <option value="{{ $subcat->id }}" {{ $product->sub_category_id == $subcat->id ? 'selected' : '' }}>
                                                {{ $subcat->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-lg-4">
                                    <label class="form-label">Product Name</label>
                                    <input type="text" name="name" value="{{ $product->name }}" class="form-control" required>
                                </div>

                                <div class="col-lg-4">
                                    <label class="form-label">Price</label>
                                    <input type="number" name="price" value="{{ $product->price }}" class="form-control" required>
                                </div>

                                <div class="col-lg-4">
                                    <label class="form-label">Discount Price</label>
                                    <input type="number" name="discount_price" value="{{ $product->discount_price }}" class="form-control">
                                </div>

                                <div class="col-lg-4">
                                    <label class="form-label">Country</label>
                                    <select class="form-control" id="choices-multiple-remove-button" data-choices data-choices-removeItem name="country[]" multiple>
    @foreach(App\Models\Country::get() as $country)
        <option value="{{ $country->id }}"
            {{ isset($product) && $product->countries->contains($country->id) ? 'selected' : '' }}>
            {{ $country->name }}
        </option>
    @endforeach
</select>

                                </div>

                                <!-- Images -->
                                <div class="col-lg-4">
                                    <label class="form-label">Add New Images (Multiple)</label>
                                    <input type="file" name="images[]" id="imageInput" class="form-control" multiple accept="image/*">
                                    <div id="previewContainer" class="mt-2"></div>
                                </div>

                                <div class="col-lg-2">
                                    <label class="form-label">Existing Images</label>
                                    <div class="d-flex flex-wrap">
                                        @foreach($product->images as $img)
                                            <img src="{{ asset('uploads/products/' . $img->image) }}" width="100" height="80" class="m-1 rounded">
                                        @endforeach
                                    </div>
                                </div>

                                 <div class="col-lg-2">
                                    <label class="form-label">Status</label>
                                    <select name="status" class="form-control">
                                        <option value="1" {{ $product->status == '1' ? 'selected' : '' }}>Active</option>
                                        <option value="0" {{ $product->status == '0' ? 'selected' : '' }}>Inactive</option>
                                    </select>
                                </div>
                                <!-- Product Type -->
                                <div class="col-lg-4">
                                    <label class="form-label">Product Type</label>
                                    <select name="product_type" id="product_type" class="form-control">
                                        <option value="standard" {{ $product->product_type == 'standard' ? 'selected' : '' }}>Standard</option>
                                        <option value="hamper" {{ $product->product_type == 'hamper' ? 'selected' : '' }}>Hamper</option>
                                        <option value="customized_gift" {{ $product->product_type == 'customized_gift' ? 'selected' : '' }}>Customized Gift</option>
                                        <option value="gift_voucher" {{ $product->product_type == 'gift_voucher' ? 'selected' : '' }}>Gift Voucher</option>
                                    </select>
                                </div>

                                <!-- Customized Gift -->
                                <div class="col-lg-4 customFields d-none">
                                    <label>Custom Photo</label>
                                    <input type="file" name="custom_photo" id="customPhotoInput" accept="image/*" class="form-control">
                                    @if($product->custom_photo)
                                        <img src="{{ asset('uploads/products/custom/' . $product->custom_photo) }}" width="100" class="mt-2 rounded">
                                    @endif
                                    <div id="customPhotoPreview"></div>
                                </div>

                                <div class="col-lg-4 customFields d-none">
                                    <label>Custom Text</label>
                                    <input type="text" name="custom_text" value="{{ $product->custom_text }}" class="form-control">
                                </div>

                                <div class="col-lg-4 customFields d-none">
                                    <label>Custom Color</label>
                                    <input type="color" name="custom_color" value="{{ $product->custom_color }}" class="form-control">
                                </div>

                                <div class="col-lg-12 customFields d-none">
                                    <label>Custom Message</label>
                                    <textarea name="custom_message" class="form-control">{{ $product->custom_message }}</textarea>
                                </div>

                                <!-- Voucher Fields -->
                                <div class="col-lg-4 voucherFields d-none">
                                    <label>Voucher Brand</label>
                                    <input type="text" name="voucher_brand" value="{{ $product->voucher_brand }}" class="form-control">
                                </div>

                                <div class="col-lg-4 voucherFields d-none">
                                    <label>Voucher Code</label>
                                    <input type="text" name="voucher_code" value="{{ $product->voucher_code }}" class="form-control">
                                </div>

                                <div class="col-lg-4 voucherFields d-none">
                                    <label>Voucher Amount</label>
                                    <input type="number" name="voucher_amount" value="{{ $product->voucher_amount }}" class="form-control">
                                </div>

                                <div class="col-lg-4 voucherFields d-none">
                                    <label>Voucher Value</label>
                                    <input type="number" name="voucher_value" value="{{ $product->voucher_value }}" class="form-control">
                                </div>

                                <div class="col-lg-4 voucherFields d-none">
                                    <label>Start Date</label>
                                    <input type="date" name="voucher_start_date" value="{{ $product->voucher_start_date }}" class="form-control">
                                </div>

                                <div class="col-lg-4 voucherFields d-none">
                                    <label>End Date</label>
                                    <input type="date" name="voucher_end_date" value="{{ $product->voucher_end_date }}" class="form-control">
                                </div>

                                <!-- Description -->
                                <div class="col-lg-12">
                                    <label>Description</label>
                                    <div id="snow-editor" style="height:200px;">{!! $product->description !!}</div>
                                    <input type="hidden" name="description" id="description">
                                </div>

                            </div>

                            <div class="text-end mt-3">
                                <button type="submit" class="btn btn-primary">Update Product</button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<!-- ========================== JAVASCRIPT ========================== -->
<script>
$(document).ready(function() {

    function toggleFields(type) {
        $('.customFields, .voucherFields').addClass('d-none');
        if (type === 'customized_gift') $('.customFields').removeClass('d-none');
        if (type === 'gift_voucher') $('.voucherFields').removeClass('d-none');
    }

    toggleFields($('#product_type').val());

    $('#product_type').on('change', function() {
        toggleFields($(this).val());
    });

    $("#imageInput").change(function() {
        $('#previewContainer').html('');
        $.each(this.files, function(i, file) {
            let reader = new FileReader();
            reader.onload = e => $('#previewContainer').append('<img src="' + e.target.result + '" width="120" class="m-1 rounded">');
            reader.readAsDataURL(file);
        });
    });

    $("#customPhotoInput").change(function() {
        $('#customPhotoPreview').html('');
        let reader = new FileReader();
        reader.onload = e => $('#customPhotoPreview').append('<img src="' + e.target.result + '" width="120" class="m-1 rounded">');
        reader.readAsDataURL(this.files[0]);
    });

    // Initialize Quill
    var quill = new Quill('#snow-editor', { theme: 'snow' });

    $('#editProductForm').submit(function(e) {
        e.preventDefault();
        $('#description').val(quill.root.innerHTML);

        let formData = new FormData(this);
        $.ajax({
            url: "{{ route('update-product', $product->id) }}",
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,
            success: function(response) {
                Swal.fire('Success', response.success, 'success');
                window.location.reload();
            },
            error: function(xhr) {
                let errors = xhr.responseJSON.errors;
                let errMsg = '';
                $.each(errors, function(k, v) {
                     errMsg += `• ${v}<br>`;
                     });
                Swal.fire('Error', errMsg, 'error');
            }
        });
    });

});
</script>

@endsection
