<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SubCategory extends Model
{
    use HasFactory;

    protected $fillable = [
        'category_id', 'name', 'slug', 'type', 'image', 'is_active','svg_icon'
    ];

     // Override image attribute to return full URL
    protected $appends = ['image_full'];

    public function category() {
        return $this->belongsTo(Category::class);
    }

    
    // This creates image_full field
    public function getImageFullAttribute()
    {
        if (!$this->image) {
            return null;
        }

        // If image already has http or https avoid duplicating
        if (str_starts_with($this->image, 'http')) {
            return $this->image;
        }

        return url($this->image);
    }

    // OPTIONAL — replace "image" in response with full URL
    protected $hidden = ['image'];

    protected $casts = [
        'image_full' => 'string'
    ];
}
