<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    protected $fillable = [
        'order_number',
        'user_id',
        'address_id',
        'subtotal',
        'discount_amount',
        'delivery_charge',
        'total_amount',
        'delivery_details',
        'status'
    ];
    protected $casts = [
        'delivery_details' => 'array',
    ];

    public function items()
    {
        return $this->hasMany(OrderItems::class);
    }

 
public function statusHistory()
{
    return $this->hasMany(OrderStatusHistory::class, 'order_id', 'id')->orderBy('status_date');
}


    // ✅ ADD THIS
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
