<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Event extends Model
{
   protected $fillable = [
      'name',
      'type',
      'stadium_id',
      'team_a_id',
      'team_b_id',
      'start_time',
      'end_time',
      'status',
      'match_format',
      'banner_image',
      'description'
   ];

   public function stadium()
   {
      return $this->belongsTo(Stadium::class);
   }
   public function teamA()
   {
      return $this->belongsTo(Team::class, 'team_a_id');
   }
   public function teamB()
   {
      return $this->belongsTo(Team::class, 'team_b_id');
   }
   public function blocks()
   {
      return $this->hasMany(EventBlock::class);
   }
}
