<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Cache;
use App\Models\Cart;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
class LoginController extends Controller
{
     // STEP 1: Send OTP
    public function sendOtp(Request $request)
    {
        $request->validate([
            'phone' => 'required'
        ]);

        $phone = $request->phone;

        // 6-digit OTP
      //  $otp = rand(100000, 999999);
$otp = '123456';
        // Store in Cache for 5 minutes
        Cache::put("otp_$phone", $otp, now()->addMinutes(5));

        // In real app: send via SMS
        // For testing we return OTP
        return response()->json([
            'message' => 'OTP sent successfully',
           // 'otp' => $otp   // remove in production
        ]);
    }

    // STEP 2: Verify OTP and login
    public function verifyOtp(Request $request)
    {
        $request->validate([
            'phone' => 'required',
            'otp'   => 'required'
        ]);

        $phone = $request->phone;
        $otp   = $request->otp;

        $savedOtp = Cache::get("otp_$phone");

        if (!$savedOtp) {
            return response()->json(['message' => 'OTP expired'], 400);
        }

        if ($savedOtp != $otp) {
            return response()->json(['message' => 'Invalid OTP'], 400);
        }

        // OTP correct → find or create user
        $user = User::firstOrCreate(
            ['phone' => $phone],
            ['name' => 'New User']
        );
     
        $deviceId = $request->header('device_id') ?? session()->getId();

        Cart::where('session_id', $deviceId)
            ->update(['user_id' => $user->id]);

        // Clear OTP
        Cache::forget("otp_$phone");

        // Create Sanctum token
        $token = $user->createToken("api_token")->plainTextToken;

        return response()->json([
            'message' => 'Login successful',
            'token' => $token,
            'user' => $user
        ]);
    }

    public function logout(Request $request)
{
    // Delete only the current token
    $request->user()->currentAccessToken()->delete();

    return response()->json([
        'status' => true,
        'message' => 'Logged out successfully'
    ]);
}


public function updateProfile(Request $request)
{
    $user = Auth::user();

    // ✅ Validation
    $validator = Validator::make($request->all(), [
        'name'          => 'required|string|max:255',
        'email'         => 'required|email|unique:users,email,' . $user->id,
        'phone'         => 'nullable|string|max:20',
        'profile_image' => 'nullable|image|mimes:jpg,jpeg,png,webp,gif|max:2048',
    ]);

    if ($validator->fails()) {
        return response()->json([
            'status' => false,
            'errors' => $validator->errors()
        ], 422);
    }

    // ✅ Update fields
    $user->name  = $request->name;
    $user->email = $request->email;
    $user->phone = $request->phone;
    $user->dob = date('Y-m-d', strtotime($request->dob));
    $user->gender = $request->gender;

    // ✅ Image upload
    if ($request->hasFile('profile_image')) {

        $image = $request->file('profile_image');
        $imageName = time() . '-' . rand(100, 999) . '.' . $image->extension();
        $uploadPath = public_path('assets/upload/user/');

        if (!File::exists($uploadPath)) {
            File::makeDirectory($uploadPath, 0755, true);
        }

        // Delete old image
        if ($user->profile_image && File::exists(public_path($user->profile_image))) {
            File::delete(public_path($user->profile_image));
        }

        $image->move($uploadPath, $imageName);
        $user->profile_image = 'assets/upload/user/' . $imageName; // ✅ SEMICOLON FIXED
    }

    $user->save();

    // ✅ Response
    return response()->json([
        'status'  => true,
        'message' => 'Profile updated successfully',
        // 'data' => [
        //     'name'  => $user->name,
        //     'email' => $user->email,
        //     'phone' => $user->phone,
        //     'profile_image' => $user->profile_image
        //         ? url($user->profile_image)
        //         : null,
        // ]
    ]);
}

}
