<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\CategoryController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\SubCategoryController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\BannerController;
use App\Http\Controllers\CouponController;
use App\Http\Controllers\StockController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\BrandController;
use App\Http\Controllers\DepartmentController;
use App\Http\Controllers\NotificationController;
//**************************** step 1: permissions *******************/
Route::get('/', function () {
    return view('auth.login');
});
Route::get('get-subcategories/{category_id}', function ($category_id) {
    return App\Models\SubCategory::where('category_id', $category_id)->get(['id', 'name']);
});
Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

  Route::get(
    '/get.department.users',
    [UserController::class, 'getDepartmentUsers']
)->name('get.department.users');

    // route
    Route::get(
        '/roles/{role}/departments',
        [UserController::class, 'getRoleDepartments']
    )->name('roles.departments');

Route::middleware(['auth', 'checkpermission'])->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // Room routes

    Route::get('/room', function () {
        return view('admin.product.room');
    })->name('room.index');
    Route::controller(SettingsController::class)->group(function () {
        Route::get('/get/room', 'getroom')->name('get-room');
        Route::post('/add/room', 'addroom')->name('add-room');
        Route::delete('/delete-room/{id}', 'destroy')->name('delete-room');
        Route::put('/update-room/{id}', 'update')->name('update-room');

        // room routes

    });
    // tag routes

    Route::get('/tags', function () {
        return view('admin.product.tags');
    })->name('tag.index');
    Route::controller(SettingsController::class)->group(function () {
        Route::get('/get/tag', 'gettag')->name('get-tag');
        Route::post('/add/tag', 'addtag')->name('add-tag');
        Route::delete('/delete-tag/{id}', 'destroytag')->name('delete-tag');
        Route::put('/update-tag/{id}', 'updatetag')->name('update-tag');
    });
    // tag routes


    // category routes
    Route::get('/category', function () {
        return view('admin.product.category');
    })->name('category.index');

    // Settings Controller routes
    Route::controller(CategoryController::class)->group(function () {
        Route::get('/get/category', 'getcategory')->name('get-category');
        Route::post('/add/category', 'addcategory')->name('add-category');
        Route::delete('/delete-category/{id}', 'destroy')->name('delete-category');
        Route::put('/update-category/{id}', 'update')->name('update-category');
    });
    // category routes


    // subcategory start 
    // SubCategory Routes
    Route::get('/subcategory', function () {
        return view('admin.product.subcategory');
    })->name('subcategory');

    Route::get('/get-subcategory', [SubCategoryController::class, 'getSubCategory'])->name('get-subcategory');
    Route::post('/add-subcategory', [SubCategoryController::class, 'addSubCategory'])->name('add-subcategory');
    Route::post('/update-subcategory/{id}', [SubCategoryController::class, 'update'])->name('update-subcategory');
    Route::delete('/delete-subcategory/{id}', [SubCategoryController::class, 'destroy'])->name('delete-subcategory');
    Route::post('/toggle-subcategory-status/{id}', [SubCategoryController::class, 'toggleStatus'])->name('toggle-subcategory-status');

    // subcategory end

    //products start
    Route::get('/add-product', function () {
        return view('admin.product.add-product');
    })->name('add-product');
    Route::post('product-store', [ProductController::class, 'store'])->name('product.store');


    Route::post('/products/step-one', [ProductController::class, 'storeStepOne'])
        ->name('products.step.one');
    Route::post('/products/step-two', [ProductController::class, 'storeStepTwo'])
        ->name('product.step2.store');
    Route::post('/product-images', [ProductController::class, 'storeImages'])
        ->name('product.images.store');
    Route::post('/product/stock', [ProductController::class, 'storeStock'])
        ->name('stocks.store');
        
    Route::get('product-list', [ProductController::class, 'index'])->name('products');
    Route::get('get-product-list', [ProductController::class, 'getProducts'])->name('get-products');
Route::get('/products/variant/form', [ProductController::class, 'variantForm'])
    ->name('products.variant.form');
Route::post('/products/variant/delete', [ProductController::class, 'deleteVariant'])
    ->name('products.variant.delete');
    Route::get('get-product/{id}', [ProductController::class, 'show'])->name('edit-product');
    Route::delete('delete-product/{id}', [ProductController::class, 'destroy'])->name('delete-product');
    Route::post(
        'products/step-one/update',
        [ProductController::class, 'stepOneUpdate']
    )->name('products.step.one.update');

    Route::post(
        'products/step-two/update',
        [ProductController::class, 'stepTwoUpdate']
    )->name('products.step.two.update');

    Route::post(
        'products/step-three/update',
        [ProductController::class, 'stepThreeUpdate']
    )->name('products.step.three.update');

    Route::post(
        'products/image/delete',
        [ProductController::class, 'deleteImage']
    )->name('products.image.delete');


    Route::post('product/step-four/update', [ProductController::class, 'updateStock'])
        ->name('products.step.four.update');
    // web.php
    Route::delete('/stocks/{stock}', [ProductController::class, 'destroyStock'])->name('stocks.delete');


    // banner start
    Route::get('banner', function () {
        return view('admin.banner');
    })->name('banner');
    Route::get('get-banner', [BannerController::class, 'getBanner'])->name('get-banner');
    Route::post('add-banner', [BannerController::class, 'addBanner'])->name('add-banner');
    Route::delete('banner-delete/{id}', [BannerController::class, 'destroy'])->name('banner-delete');
    Route::put('update-banner/{id}', [BannerController::class, 'update'])->name('update-banner');
    Route::get('banner/get-products/{category_id}', [ProductController::class, 'getProductsByCategory'])->name('banner.get.products');
    Route::post('banner/status/{id}', [BannerController::class, 'changeStatus'])->name('banner.status');

    // banner end

    // gift offers



    //coupon
    Route::get('/coupons', [CouponController::class, 'index'])->name('coupons');
    Route::get('/get-coupons', [CouponController::class, 'getCoupons'])->name('get-coupons');
    Route::post('/add-coupon', [CouponController::class, 'store'])->name('add-coupon');
    Route::get('/coupon/edit/{id}', [CouponController::class, 'edit'])->name('edit-coupon');
    Route::post('/coupon/update/{id}', [CouponController::class, 'update'])->name('update-coupon');
    Route::delete('/coupon-delete/{id}', [CouponController::class, 'destroy'])->name('coupon-delete');
    Route::post('/coupon/status/{id}', [CouponController::class, 'changeStatus'])->name('status-coupon');


    Route::get('/get-products/{category_id}', [CouponController::class, 'getProducts'])->name('get-products-coupon');


    Route::get('/coupons/{id}/edit', [CouponController::class, 'edit'])->name('edit-coupon');
    Route::get('/get-countries-list', [CouponController::class, 'getCountries']); // helper route

    // end coupon
    Route::get('stock-inventory', [StockController::class, 'index'])->name('stock.index');
    Route::get('get-stock', [StockController::class, 'getStock'])->name('stock.list');

    Route::get('/stock-view/{id}', [StockController::class, 'view'])->name('stock.view');
    Route::get('/stock-edit/{id}', [StockController::class, 'edit'])->name('stock.edit');
    Route::get('/stock/{location}', [StockController::class, 'viewStocks'])
        ->name('stock.view.details');


    // locations Routes
    Route::get('/locations', function () {
        return view('admin.stock.locations');
    })->name('locations');
    Route::get('/add/locations', function () {
        return view('admin.stock.add_location');
    })->name('add-locations');
    Route::get('/get-locations', [StockController::class, 'getlocations'])->name('get-locations');
    Route::post('/save-locations', [StockController::class, 'savelocations'])->name('save-locations');
    Route::post('/update-locations', [StockController::class, 'update'])->name('update-locations');
    Route::delete('/delete-locations/{id}', [StockController::class, 'destroy'])->name('delete-locations');
    Route::get('/edit-locations/{id}', [StockController::class, 'editLocation'])->name('edit-location');
    //**************************** step 1: permissions end*******************/


    //**************************** roles *******************/
    Route::get('/roles/create', [RoleController::class, 'create'])->name('roles.create');
    Route::post('/roles', [RoleController::class, 'store'])->name('roles.store');
    Route::get('/roles', [RoleController::class, 'index'])->name('roles.index');
    Route::get('/roles/{role}/edit', [RoleController::class, 'edit'])->name('roles.edit');
    Route::post('/update/role/{role}', [RoleController::class, 'update'])->name('roles.update');
    Route::delete('/roles/{role}', [RoleController::class, 'destroy'])->name('roles.destroy');
    Route::get('/deleteSelectedPermissions', [RoleController::class, 'deleteSelectedPermissions'])->name('deleteSelectedPermissions');



    //**************************** roles end *******************/
     //**************************** users *******************/
    Route::get('/users', [UserController::class, 'index'])->name('users.index');
    Route::post('/users', [UserController::class, 'store'])->name('users.store');
    Route::get('/users/{user}/edit', [UserController::class, 'edit'])->name('users.edit');
    Route::put('/users/{user}', [UserController::class, 'update'])->name('users.update');
    Route::delete('/users/{user}', [UserController::class, 'destroy'])->name('users.destroy');
  Route::get('/users/{id}', [UserController::class, 'show'])->name('users.view');
    Route::get('/users/{user}/login-history', [UserController::class, 'loginHistory'])
    ->name('users.login.history');

Route::delete('/login-history/{activity}', [UserController::class, 'deleteLoginActivity'])
    ->name('login.history.delete');

Route::delete('/users/{user}/login-history/delete-all', [UserController::class, 'deleteAllLoginHistory'])
    ->name('users.login.history.deleteAll');

    Route::get(
    '/users/{user}/assignable-users',
    [UserController::class, 'getAssignableUsers']
)->name('users.assignable.users');

Route::get(
    '/users/{user}/assignable-locations',
    [UserController::class, 'getAssignableLocations']
)->name('users.assignable.locations');

Route::post(
    '/users/save-assignments',
    [UserController::class, 'saveAssignments']
)->name('users.assign.save');


    //**************************** users end *******************/


    //****************************department  ****************************/


    Route::get('departments', [DepartmentController::class, 'index'])->name('departments');
    Route::post('add-department', [DepartmentController::class, 'store'])->name('add-department');

    Route::get('get-departments', [DepartmentController::class, 'list'])->name('get-departments');

    Route::put('update-department/{id}', [DepartmentController::class, 'update'])->name('update-department');
    Route::delete('delete-department/{id}', [DepartmentController::class, 'destroy'])->name('delete-department');

    Route::post('department-status/{id}', [DepartmentController::class, 'changeStatus'])->name('department-status');
    //****************************department  end ****************************/

    //****************************notification ****************************/
    Route::post('/notifications/clear', function () {
        auth()->user()->unreadNotifications->markAsRead();
        return back();
    })->name('notifications.clear');
    Route::post('/notifications/read/{id}', function ($id) {
        auth()->user()->notifications()->where('id', $id)->first()?->markAsRead();
    });
    Route::get('/notifications', [NotificationController::class, 'index'])
        ->name('notifications.index');

    Route::get('/notifications/read/{id}', [NotificationController::class, 'read'])
        ->name('notifications.read');

    Route::post('/notifications/read-all', [NotificationController::class, 'readAll'])
        ->name('notifications.readAll');

    Route::delete('/notifications/{id}', [NotificationController::class, 'destroy'])
        ->name('notifications.destroy');

    Route::delete('/notifications', [NotificationController::class, 'destroyAll'])
        ->name('notifications.destroyAll');
    //**************************** notification end ****************************/


    // brand routes
    Route::get('/brand', function () {
        return view('admin.product.brand');
    })->name('brand.index');

    // Settings Controller routes
    Route::controller(BrandController::class)->group(function () {
        Route::get('/get/brand', 'getbrand')->name('get-brand');
        Route::post('/add/brand', 'addbrand')->name('add-brand');
        Route::delete('/delete-brand/{id}', 'destroy')->name('delete-brand');
        Route::put('/update-brand/{id}', 'update')->name('update-brand');
    });
    // brand routes


});

require __DIR__ . '/auth.php';
