<?php
// use Illuminate\Auth\Middleware\Authenticate;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\HomeController;
use App\Http\Controllers\Api\LoginController;
use App\Http\Controllers\Api\CartController;
use App\Http\Controllers\Api\ProductController;
use App\Http\Controllers\Api\OrderController;
use App\Http\Controllers\Api\WishlistController;

// Guest Cart



Route::post('/login', [LoginController::class, 'login']);

Route::post('/test/login', [LoginController::class, 'testlogin']);

// After Login (Secure Routes)
Route::middleware(['auth:sanctum'])->group(function () {
    Route::post('/wishlist/add', [WishlistController::class, 'add']);
    Route::delete('/wishlist/remove', [WishlistController::class, 'remove']);
    Route::get('/wishlist', [WishlistController::class, 'list']);

    Route::get('/banners', [HomeController::class, 'banners']);
    Route::post('/banner/{id}/view', [HomeController::class, 'bannerView']);
    Route::post('/banner/{id}/click', [HomeController::class, 'bannerClick']);
    Route::prefix('home')->group(function () {
        Route::get('/flash-sale/tags', [HomeController::class, 'tags']);
        Route::get('/flash-sale/products/{tagId?}', [HomeController::class, 'productsByTag']);


        Route::get('special-for-you', [HomeController::class, 'specialForYou']);
        Route::get('explore-luxury-curtains', [HomeController::class, 'exploreLuxuryCurtains']);
        Route::get('brands', [HomeController::class, 'brands']);
        Route::get('best-seller/categories', [HomeController::class, 'bestSellerCategories']);
        Route::get('best-seller/products/{category_id}', [HomeController::class, 'bestSellerProducts']);
        Route::get('/search', [HomeController::class, 'search']);
        Route::get('/categories', [HomeController::class, 'categories']);
    });


    Route::post('/products', [ProductController::class, 'listing']);
    Route::get('/products/{id}', [ProductController::class, 'show']);

    Route::get('/profile', function () {
        return response()->json([
            'status' => true,
            'data' => auth()->user()
        ]);
    });
    Route::post('/profile/update', [LoginController::class, 'updateProfile']);
    Route::post('/profile/full/update', [LoginController::class, 'updatefullProfile']);
    Route::post('/logout', [LoginController::class, 'logout']);



    Route::get('/rooms', [ProductController::class, 'rooms']);
    Route::get('/categories', [ProductController::class, 'categories']);

    //cart
    Route::post('/cart/add', [CartController::class, 'addToCart']);
    Route::post('/cart/update-quantity', [CartController::class, 'updateQuantity']);
    Route::get('/cart', [CartController::class, 'index']);
    Route::delete('/cart/remove/{cartItemId}', [CartController::class, 'remove']);
});
