@extends('admin.layout.template')

@section('title', 'User Profile')

@section('content')
<div class="page-content">
    <div class="container-xxl">

        {{-- USER BASIC INFO --}}
        <div class="card mb-4">
            <div class="card-body d-flex align-items-center">
                <img src="{{asset('assets/images/users/avatar-1.jpg')}}"
                    class="rounded-circle me-4"
                    width="90" height="90">

                <div class="flex-grow-1">
                    <h4 class="mb-1">{{ $user->name }}</h4>
                    <div class="text-muted">{{ $user->email }}</div>
                    <div class="badge bg-success mt-2">{{ $user->status }}</div>
                </div>

                <div class="text-end">
                    <div><strong>Role:</strong> {{ $user->getRoleNames()->implode(', ') ?? '-' }}</div>
                    <div><strong>Departments:</strong>
                @php $role = $user->roles->first(); @endphp
                @forelse($role?->departments ?? [] as $dept)
                    <span class="badge bg-primary me-1">{{ $dept->name }}</span>
                @empty
                    <span class="text-muted">—</span>
                @endforelse</div>
                    <div><strong>User Type:</strong> {{ ucfirst($user->user_type) }}</div>
                </div>
            </div>
        </div>
    
        <div class="card mb-4">
    <div class="card-header fw-bold">User Details</div>
    <div class="card-body">
        <div class="row g-3">

            <!-- Basic Info -->
            <div class="col-md-4"><strong>Phone:</strong> {{ $user->phone }}</div>
            <div class="col-md-4"><strong>City:</strong> {{ $user->city }}</div>
            <div class="col-md-4"><strong>State:</strong> {{ $user->state }}</div>
            <div class="col-md-4"><strong>Country:</strong> {{ $user->country }}</div>
            <div class="col-md-4"><strong>Pincode:</strong> {{ $user->pincode }}</div>
            <div class="col-md-4"><strong>Joining Date:</strong> {{ $user->joining_date ?? '-' }}</div>
            <div class="col-md-4"><strong>Reporting Manager:</strong> {{ optional($user->manager)->name ?? '-' }}</div>
            <div class="col-md-4"><strong>Access Expiry:</strong> {{ $user->access_expires_at ?? 'N/A' }}</div>
            <div class="col-md-4"><strong>Last Login:</strong> {{ $user->last_login_at ?? 'Never' }}</div>
            <div class="col-12"><strong>Address:</strong> {{ $user->address ?? '-' }}</div>

            <!-- Departments (from role) -->
            <div class="col-12">
                <strong>Departments:</strong>
                @php $role = $user->roles->first(); @endphp
                @forelse($role?->departments ?? [] as $dept)
                    <span class="badge bg-primary me-1">{{ $dept->name }}</span>
                @empty
                    <span class="text-muted">—</span>
                @endforelse
            </div>

            <!-- Assigned Users -->
            <div class="col-12 mt-2">
                <strong>Assigned Users:</strong>
                @forelse($user->assignedUsers ?? [] as $assigned)
                    <span class="badge bg-success me-1">{{ $assigned->name }}</span>
                @empty
                    <span class="text-muted">—</span>
                @endforelse
            </div>

            <!-- Assigned Locations -->
            <div class="col-12 mt-2">
                <strong>Assigned Locations:</strong>
                @forelse($user->locations ?? [] as $loc)
                    <span class="badge bg-info me-1">{{ $loc->name }}</span>
                @empty
                    <span class="text-muted">—</span>
                @endforelse
            </div>

        </div>
    </div>
</div>

        <div class="card">
            <div class="card-body">
                <ul class="nav nav-tabs mb-3" role="tablist">
                    <li class="nav-item">
                        <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#activity">
                            Activity History
                        </button>
                    </li>
                    <li class="nav-item">
                        <button class="nav-link" data-bs-toggle="tab" data-bs-target="#login" id="login-tab">
                            Login / Logout History
                        </button>
                    </li>
                </ul>

                <div class="tab-content">
                    <div class="tab-pane fade show active" id="activity">
                        <div class="d-flex justify-content-between mb-3">
                            <h4>
                                User Activities – {{ $user->name }}
                                @if($user->isOnline())
                                <span class="badge bg-success">Online</span>
                                @else
                                <span class="badge bg-secondary">Offline</span>
                                @endif
                            </h4>

                            <button class="btn btn-danger" id="deleteAllActivities">
                                Delete All Activities
                            </button>
                        </div>

                        <table class="table table-striped" id="activitytable">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Event</th>
                                    <th>Description</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($activities as $log)
                                <tr>
                                    <td>{{ $log->created_at->format('d M Y H:i') }}</td>
                                    <td>
                                        <span class="badge bg-primary">{{ $log->event_type }}</span>
                                    </td>
                                    <td>{!! $log->description !!}</td>
                                </tr>
                                @empty
                                <tr>
                                    <td class="text-center">—</td>
                                    <td class="text-center">—</td>
                                    <td class="text-center">No activity found</td>
                                </tr>
                                @endforelse

                            </tbody>
                        </table>
                    </div>


                    <div class="tab-pane fade" id="login">


                        <div class="d-flex justify-content-between mb-3">
                            <h4>
                                Login History – {{ $user->name }}
                                @if($user->isOnline())
                                <span class="badge bg-success">Online</span>
                                @else
                                <span class="badge bg-secondary">Offline</span>
                                @endif
                            </h4>

                            <button class="btn btn-danger" id="deleteAll">
                                Delete All History
                            </button>
                        </div>

                        <div class="card">
                            <div class="card-body">
                                <table class="table table-striped" id="historyTable">
                                    <thead>
                                        <tr>
                                            <th>Login At</th>
                                            <th>Logout At</th>
                                            <th>Device</th>
                                            <th>IP Address</th>
                                            <th width="100">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($loginLogs as $activity)
                                        <tr id="row-{{ $activity->id }}">
                                            <td>{{ $activity->login_at }}</td>
                                            <td>{{ $activity->logout_at ?? '—' }}</td>
                                            <td>{{ $activity->device }}</td>
                                            <td>{{ $activity->ip_address }}</td>
                                            <td>
                                                <button class="btn btn-sm btn-danger deleteActivity"
                                                    data-id="{{ $activity->id }}">
                                                    Delete
                                                </button>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>


                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        $('.table').DataTable();

        // Delete single activity
        $('.deleteActivity').click(function() {
            let id = $(this).data('id');

            Swal.fire({
                title: 'Delete this record?',
                icon: 'warning',
                showCancelButton: true
            }).then(res => {
                if (res.isConfirmed) {
                    $.ajax({
                        url: "{{ url('login-history') }}/" + id,
                        type: 'DELETE',
                        data: {
                            _token: '{{ csrf_token() }}'
                        },
                        success: function() {
                            $('#row-' + id).remove();
                        }
                    });
                }
            });
        });

        // Delete all history
        $('#deleteAll').click(function() {
            Swal.fire({
                title: 'Delete ALL login history?',
                text: 'This action cannot be undone!',
                icon: 'warning',
                showCancelButton: true
            }).then(res => {
                if (res.isConfirmed) {
                    $.ajax({
                        url: `{{ route('users.login.history.deleteAll', $user->id) }}`,
                        type: 'DELETE',
                        data: {
                            _token: '{{ csrf_token() }}'
                        },
                        success: function() {
                            location.reload();
                        }
                    });
                }
            });
        });

        // Delete all Activities
        $('#deleteAllActivities').click(function() {
            Swal.fire({
                title: 'Delete ALL login history?',
                text: 'This action cannot be undone!',
                icon: 'warning',
                showCancelButton: true
            }).then(res => {
                if (res.isConfirmed) {
                    $.ajax({
                        url: `{{ route('users.login.history.deleteAll', $user->id) }}`,
                        type: 'DELETE',
                        data: {
                            _token: '{{ csrf_token() }}'
                        },
                        success: function() {
                            location.reload();
                        }
                    });
                }
            });
        });
    });
</script>
@endsection