@extends('admin.layout.template')
@section('title', isset($user) ? 'Edit User' : 'Add User')
@section('content')

<div class="page-content">
    <div class="container-xxl">

        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 py-0">
                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{ route('users.index') }}">Users</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{ isset($user) ? 'Edit User' : 'Add User' }}</li>
            </ol>
        </nav>

        <div class="card">
            <div class="card-body">

                <form id="userForm" >
                    @csrf
                    @if(isset($user))
                        @method('PUT')
                    @endif

                    <input type="hidden" id="user_id" value="{{ $user->id ?? '' }}">

                    <div class="row g-3">

                        <!-- Name -->
                        <div class="col-md-4">
                            <label class="form-label">Name</label>
                            <input type="text" class="form-control" name="name" required value="{{ old('name', $user->name ?? '') }}">
                        </div>

                        <!-- Email -->
                        <div class="col-md-4">
                            <label class="form-label">Email</label>
                            <input type="email" class="form-control" name="email" required value="{{ old('email', $user->email ?? '') }}">
                        </div>

                        <!-- Phone -->
                        <div class="col-md-4">
                            <label class="form-label">Phone</label>
                            <input type="text" class="form-control" name="phone" value="{{ old('phone', $user->phone ?? '') }}">
                        </div>

                        <!-- Password -->
                        <div class="col-md-4">
                            <label class="form-label">Password</label>
                            <input type="password" class="form-control" name="password">
                            @if(isset($user))
                                <small class="text-muted">Leave blank to keep existing</small>
                            @endif
                        </div>

                        <!-- Role -->
                        <div class="col-md-4">
                            <label class="form-label">Role</label>
                            <select class="form-select" name="role" id="roleSelect" required>
                                <option value="">Select Role</option>
                                @foreach(\Spatie\Permission\Models\Role::all() as $role)
                                    <option value="{{ $role->id }}" {{ isset($user) && $user->role_id == $role->id ? 'selected' : '' }}>
                                        {{ ucfirst($role->name) }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <!-- User Type -->
                        <div class="col-md-4">
                            <label class="form-label">User Type</label>
                            <select class="form-select" name="user_type" required>
                                <option value="">Select Type</option>
                                @php
                                    $types = ['super_admin','cusella_internal','zonal_franchise','franchise','dealer','architect','customer'];
                                @endphp
                                @foreach($types as $type)
                                    <option value="{{ $type }}" {{ isset($user) && $user->user_type == $type ? 'selected' : '' }}>
                                        {{ ucwords(str_replace('_',' ',$type)) }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Departments -->
                        <!-- <div class="col-md-4">
                            <label class="form-label">Departments</label>
                            <select class="form-select department_id" name="department[]" multiple data-choices>
                                @foreach(\App\Models\Department::orderBy('name')->get() as $dept)
                                    <option value="{{ $dept->id }}" 
                                        {{ isset($user) && in_array($dept->id, old('department', $user->departments->pluck('id')->toArray() ?? [])) ? 'selected' : '' }}>
                                        {{ $dept->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div> -->

                        <!-- Reporting Manager -->
                        <div class="col-md-4">
                            <label class="form-label">Reporting Manager</label>
                            <select class="form-select" name="reporting_manager_id" data-choices>
                                <option value="">Select Manager</option>
                                @foreach(\App\Models\User::orderBy('name')->get() as $manager)
                                    <option value="{{ $manager->id }}" {{ isset($user) && $user->reporting_manager_id == $manager->id ? 'selected' : '' }}>
                                        {{ $manager->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Assigned Locations -->
                        <div class="col-md-4">
                            <label class="form-label">Assigned Locations</label>
                            <select class="form-select assigned_locations" name="assigned_locations[]" multiple data-choices>
                                @foreach(App\Models\Location::orderBy('name')->get() as $location)
                                    <option value="{{ $location->id }}"
                                        {{ isset($user) && in_array($location->id, old('assigned_locations', $user->locations->pluck('id')->toArray() ?? [])) ? 'selected' : '' }}>
                                        {{ $location->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Assigned Users -->
                        <div class="col-md-4">
                            <label class="form-label">Assigned Users</label>
                            <select class="form-select assigned_users" id="assignedUsersSelect" name="assigned_users[]" multiple data-choices>
                                @php
                                    $selectedDepartments = old('department', isset($user) ? $user->departments->pluck('id')->toArray() : []);
                                    $assignedUsers = \App\Models\User::whereHas('departments', function($q) use ($selectedDepartments) {
                                        $q->whereIn('departments.id', $selectedDepartments);
                                    })->get();
                                @endphp
                                @foreach($assignedUsers as $assignedUser)
                                    <option value="{{ $assignedUser->id }}" 
                                        {{ isset($user) && in_array($assignedUser->id, old('assigned_users', $user->assignedUsers->pluck('id')->toArray() ?? [])) ? 'selected' : '' }}>
                                        {{ $assignedUser->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Joining Date -->
                        <div class="col-md-4">
                            <label class="form-label">Joining Date</label>
                            <input type="date" class="form-control" name="joining_date" 
                                value="{{ old('joining_date', isset($user) && $user->joining_date ? $user->joining_date->format('Y-m-d') : '') }}">
                        </div>

                        <!-- Access Expiry -->
                        <div class="col-md-4">
                            <label class="form-label">Access Expiry</label>
                            <input type="date" class="form-control" name="access_expires_at" 
                                value="{{ old('access_expires_at', isset($user) && $user->access_expires_at ? $user->access_expires_at->format('Y-m-d') : '') }}">
                        </div>

                        <!-- Status -->
                        <div class="col-md-4">
                            <label class="form-label">Status</label>
                            <select class="form-select" name="status" required>
                                <option value="Active" {{ isset($user) && $user->status == 'Active' ? 'selected' : '' }}>Active</option>
                                <option value="Block" {{ isset($user) && $user->status == 'Block' ? 'selected' : '' }}>Blocked</option>
                            </select>
                        </div>

                    </div>

                    <div class="modal-footer mt-3">
                        <a href="{{ route('users.index') }}" class="btn btn-light">Cancel</a>
                        <button type="submit" class="btn btn-primary">{{ isset($user) ? 'Update User' : 'Save User' }}</button>
                    </div>
                </form>

            </div>
        </div>

    </div>
</div>

<script>
   $('#userForm').submit(function(e) {
        e.preventDefault();
        const id = userId;
        const url = "{{ isset($user) ? route('users.update', $user->id) : route('users.store') }}";

        Swal.fire({
            title: 'Are you sure?',
            text: 'Save user details?',
            icon: 'question',
            showCancelButton: true
        }).then(res => {
            if(res.isConfirmed) {
                $.ajax({
                    url: url,
                    type: 'POST',
                    data: $(this).serialize() + (id ? '&_method=PUT' : ''),
                    success: function(res) {
                        Swal.fire('Success', res.message, 'success').then(() => location.reload());
                    },
                    error: function(xhr) {
                        let errors = xhr.responseJSON?.errors || {};
                        let html = Object.values(errors).map(e => e.join('<br>')).join('<br>');
                        Swal.fire('Error', html || 'Something went wrong!', 'error');
                    }
                });
            }
        });
    });
</script>

@endsection
