@extends('admin.layout.template')
@section('title', 'Location')
@section('content')

<div class="page-content">
    <div class="container-xxl">
<div class="row">
      <div class="col-lg-12">
        <div class="card d-flex">
          <div class="card-header d-flex justify-content-between align-items-center gap-1">
            <h4 class="card-title flex-grow-1">
             <iconify-icon icon="solar:box-bold-duotone" class="text-primary fs-20"></iconify-icon>  
            All Locations</h4>

            <a href="{{route('add-locations')}}" class="btn btn-sm btn-primary">
              Add Location
            </a>


          </div>
      
        </div>
      </div>
    </div>

        <!-- DataTable -->
        <div class="card">
            <div class="card-body table-responsive">
                <table class="table table-striped align-middle ">
                    <thead class="table-light">
                        <tr>
                            <th>SL.NO</th>
                            <th>Location Code</th>
                            <th>Location Name</th>
                            <th>Type</th>
                            <th>City</th>
                            <th>Phone</th>
                            <th>GST No</th>
                            <th>Trade License</th>
                            <th>Reporting Location</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</div>



<script>
    $(function() {
        var table = $('.table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('get-locations') }}",
            columns: [  { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
                {
                    data: 'location_code',
                    name: 'location_code'
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'type',
                    name: 'type'
                },
                {
                    data: 'city',
                    name: 'city'
                },
                {
                    data: 'phone',
                    name: 'phone'
                },
                {
                    data: 'gst_number',
                    name: 'gst_number'
                },
                {
                    data: 'trade_license_no',
                    name: 'trade_license_no'
                },
                {
                    data: 'reporting_location',
                    name: 'reporting_location'
                },
                {
                    data: 'status',
                    name: 'status'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                },
            ],
        });



        // Edit open
        $(document).on('click', '.editlocation', function() {
            $('#edit_id').val($(this).data('id'));
            $('#edit_name').val($(this).data('name'));
            $('#edit_type').val($(this).data('location'));

            let image = $(this).data('image');
            $('#editSubPreview').attr('src', image);

            $('#editSubCatModal').modal('show');
        });


     

        // Delete
        $(document).on('click', '.deletelocation', function() {
            var id = $(this).data('id');
            Swal.fire({
                title: 'Are you sure?',
                text: 'You will not be able to revert this!',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                          url: "{{ url('delete-locations') }}/" + id,
                        method: 'DELETE',
                        data: {
                            _token: '{{csrf_token()}}'
                        },
                        success: function(res) {
                            Swal.fire({
                                icon: 'success',
                                title: res.success,
                                showConfirmButton: false,
                                timer: 1500
                            });
                            table.ajax.reload();
                        }
                    });
                }
            });
        });


    });
</script>

@endsection