@extends('admin.layout.template')
@section('title', 'Products')
@section('content')

<div class="page-content">
  <div class="container-xxl">

    <!-- Add Product Card -->
    <div class="row">
      <div class="col-lg-12">
        <div class="card d-flex">
          <div class="card-header d-flex justify-content-between align-items-center gap-1">
            <h4 class="card-title flex-grow-1">
             <iconify-icon icon="solar:box-bold-duotone" class="text-primary fs-20"></iconify-icon>  
            All Product List</h4>

            <a href="{{route('add-product')}}" class="btn btn-sm btn-primary">
              Add Product
            </a>


          </div>
      
        </div>
      </div>
    </div>


    <!-- Product Table -->
    <div class="row mt-3">
      <div class="col-xl-12">
        <div class="card">
          <div class="card-body p-0">
            <div class="table-responsive">
              <table class="table align-middle mb-0 table-hover table-centered">
                <thead class="bg-light-subtle">
                  <tr>
                    <th>SL.NO</th>
                    <th>Product</th>
                    <th>Category</th>
                    <th>Subcategory</th>
                    <th>Images</th>
                    <th>Price</th>
                    <th>Stock</th>
                    <th>Status</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody></tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>

  </div>
</div>


<!-- ========================== JAVASCRIPT ========================== -->
<script>
  $(document).ready(function() {
    // Initialize DataTable
    var table = $('.table').DataTable({
      processing: true,
      serverSide: true,
      ajax: "{{ route('get-products') }}",
      // order: [
      //   [1, 'asc']
      // ],
      columns: [{
          data: 'DT_RowIndex',
          name: 'DT_RowIndex',
          orderable: false,
          searchable: false
        },
        {
          data: 'name',
          name: 'name'
        },
        {
          data: 'category',
          name: 'category'
        },
        {
          data: 'subcategory',
          name: 'subcategory'
        },
        {
          data: 'images',
          name: 'images',
          orderable: false,
          searchable: false
        },
        {
          data: 'price',
          name: 'price'
        },
        {
          data: 'stock',
          name: 'stock'
        },
        {
          data: 'status',
          name: 'status',
          orderable: false
        },
        {
          data: 'action',
          name: 'action',
          orderable: false,
          searchable: false
        }
      ]
    });



    // Delete Product
    $(document).on('click', '.deleteProduct', function() {
      var id = $(this).data('id');
      Swal.fire({
        title: 'Are you sure? Do you want to Delete this Product?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Yes, delete',
        cancelButtonText: 'Cancel'
      }).then(result => {
        if (result.isConfirmed) {
          $.ajax({
            url: "{{ url('delete-product') }}/" + id,
            type: 'DELETE',
            data: {
              _token: '{{ csrf_token() }}'
            },
            success: function(res) {
              Swal.fire({
                icon: 'success',
                title: 'Deleted!',
                text: res.success,
                timer: 1500,
                showConfirmButton: false
              });
              table.ajax.reload();
            }
          });
        }
      });
    });


  });


</script>

@endsection