@extends('admin.layout.template')
@section('title','Add Product')
@section('content')

<div class="page-content">
    <div class="container-xxl">
        <div class="tab-content mt-3">
            <div class="card p-3">
                <div class="card-header">
                    <h4 class="card-title d-flex align-items-center gap-1"><iconify-icon icon="solar:settings-bold-duotone" class="text-primary fs-20"></iconify-icon>Add Product</h4>
                </div>
                <div class="card-body">
                    <form id="stepOneForm" class="needs-validation" novalidate>
                        @csrf
                        <div class="row g-3">
                            <div class="col-lg-6">
                                <label class="form-label">Category *</label>
                                <select name="category_id" id="categorySelect" class="form-control" required>
                                    <option value="">Select Category</option>
                                    @foreach(App\Models\Category::all() as $cat)
                                    <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-lg-6">
                                <label class="form-label">Subcategory * </label>
                                <select name="sub_category_id" id="subcategorySelect" class="form-control" >
                                    <option value="">Select Subcategory</option>
                                </select>
                            </div>

                            {{-- Product Name --}}
                            <div class="col-md-6">
                                <label class="form-label">Product Name *</label>
                                <input type="text" name="name" class="form-control" required>
                            </div>

                            {{-- Material --}}
                            <!-- <div class="col-md-6">
                            <label class="form-label">Material</label>
                            <input type="text" name="material" class="form-control">
                        </div> -->

                            {{-- Pattern --}}
                            <!-- <div class="col-md-6">
                            <label class="form-label">Pattern</label>
                            <input type="text" name="pattern" class="form-control">
                        </div> -->


                            {{-- Features --}}
                            <div class="col-md-6">
                                <label class="form-label">Additional Features</label>
                                <input type="text" name="features" class="form-control"
                                    placeholder="Blackout, Washable">
                            </div>

                            {{-- Warranty --}}
                            <div class="col-md-6">
                                <label class="form-label">Warranty / Certification</label>
                                <input type="text" name="warranty_certification" class="form-control"
                                    placeholder="ISO / 1 Year">
                            </div>

                            {{-- Maintenance --}}
                            <div class="col-md-6">
                                <label class="form-label">Maintenance</label>
                                <input type="text" name="maintenance" class="form-control"
                                    placeholder="Dry clean / Spot clean">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">
                                    Master Catalogue Name <span class="text-danger">*</span>
                                </label>
                                <input type="text"
                                    name="master_catalogue_name"
                                    class="form-control"
                                    required>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">
                                    Master Catalogue Code <span class="text-danger">*</span>
                                </label>
                                <input type="text"
                                    name="master_catalogue_code"
                                    class="form-control"
                                    required>
                            </div>

                            {{-- Rooms (Multiple) --}}
                            <div class="col-md-6">
                                <label class="form-label">Rooms </label>
                                <select name="rooms[]" class="form-control" multiple data-choices>
                                    @foreach(App\Models\Room::all() as $room)
                                    <option value="{{ $room->id }}">{{ $room->name }}</option>
                                    @endforeach
                                </select>
                            </div>

                            {{-- Tags (Multiple) --}}
                            <div class="col-md-6">
                                <label class="form-label">Tags</label>
                                <select name="tags[]" class="form-control" multiple data-choices>
                                    @foreach(App\Models\Tags::all() as $tag)
                                    <option value="{{ $tag->id }}">{{ $tag->name }}</option>
                                    @endforeach
                                </select>
                            </div>

                            {{-- Measurement --}}
                            <div class="col-md-12">


                                <label class="form-label">Measurement</label>

                                <div class="row">
                                    <div class="col-md-4">
                                        <input type="number" step="0.01" name="length" class="form-control" placeholder="Length">
                                    </div>
                                    <div class="col-md-4">
                                        <input type="number" step="0.01" name="width" class="form-control" placeholder="Width">
                                    </div>
                                    <div class="col-md-4">
                                        <input type="number" step="0.01" name="height" class="form-control" placeholder="Height">
                                    </div>
                                </div>

                                <small class="text-muted">Example: 120 x 60 x 45 cm</small>


                                <!-- <input type="text" name="measurement" class="form-control"
                                placeholder="120x60 cm / 54 inch"> -->
                            </div>
                            <!-- Additional Fields for Step 1 -->
                            <div class="col-md-6">
                                <label class="form-label">Visibility *</label>
                                <select name="visibility" class="form-control" required>
                                    <option value="All">All</option>
                                    <option value="B2C">B2C</option>
                                    <option value="B2B">B2B</option>
                                    <option value="Franchise">Franchise</option>
                                </select>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">GST (%)</label>
                                <input type="number" step="0.01" name="gst_percent" class="form-control" placeholder="18.00">
                            </div>

                            <div class="col-md-6 mt-2">
                                <label class="form-label">Price Includes GST?</label>
                                <select name="gst_inclusive" class="form-control">
                                    <option value="1">Yes</option>
                                    <option value="0">No</option>
                                </select>
                            </div>

                            <div class="col-md-6 mt-2">
                                <label class="form-label">Featured Product</label>
                                <select name="is_featured" class="form-control">
                                    <option value="0">No</option>
                                    <option value="1">Yes</option>
                                </select>
                            </div>

                            <div class="col-md-4 mt-2">
                                <label class="form-label">Related Products</label>
                                <select name="related_products[]" class="form-control" multiple data-choices>
                                    @foreach(App\Models\Product::all() as $product)
                                    <option value="{{ $product->id }}">{{ $product->name }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-md-4 mt-2">
                                <label class="form-label">Cross-Sell Products</label>
                                <select name="cross_sell_products[]" class="form-control" multiple data-choices>
                                    @foreach(App\Models\Product::all() as $product)
                                    <option value="{{ $product->id }}">{{ $product->name }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-md-4 mt-2">
                                <label class="form-label">Upsell Products</label>
                                <select name="upsell_products[]" class="form-control" multiple data-choices>
                                    @foreach(App\Models\Product::all() as $product)
                                    <option value="{{ $product->id }}">{{ $product->name }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-md-12 mt-2">
                                <label class="form-label">SEO Title</label>
                                <input type="text" name="seo_title" class="form-control" placeholder="SEO Title">
                            </div>

                            <div class="col-md-12 mt-2">
                                <label class="form-label">SEO Description</label>
                                <textarea name="seo_description" class="form-control" rows="2" placeholder="SEO Description"></textarea>
                            </div>

                            <div class="col-md-12 mt-2">
                                <label class="form-label">Search Keywords</label>
                                <input type="text" name="search_keywords" class="form-control" placeholder="Comma separated keywords">
                            </div>

                            <div class="col-md-12 mt-2">
                                <label class="form-label">Care Instructions</label>
                                <textarea name="care_instructions" class="form-control" rows="2" placeholder="Wash / Clean / Use"></textarea>
                            </div>

                            <div class="col-md-6 mt-2">
                                <label class="form-label">Fast Moving</label>
                                <select name="fast_moving" class="form-control">
                                    <option value="0">No</option>
                                    <option value="1">Yes</option>
                                </select>
                            </div>

                            <div class="col-md-6 mt-2">
                                <label class="form-label">Slow Moving</label>
                                <select name="slow_moving" class="form-control">
                                    <option value="0">No</option>
                                    <option value="1">Yes</option>
                                </select>
                            </div>

                            {{-- Description --}}
                            <div class="col-md-12">
                                <label class="form-label">Description</label>
                                <textarea name="description" class="form-control" rows="4"></textarea>
                            </div>

                        </div>
                        <div class="text-end mt-4">
                            <button type="submit" class="btn btn-primary">
                                Save & Continue →
                            </button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- NAV BUTTONS -->

</div>

<script>
    $(document).ready(function() {
        $('#variantContainer').toggle();
        // Load subcategories dynamically
        $('#categorySelect').on('change', function() {
            let catId = $(this).val();
            $('#subcategorySelect').html('<option value="">Loading...</option>');
            $.get("{{ url('get-subcategories') }}/" + catId, function(data) {
                let html = '<option value="">Select Subcategory</option>';
                $.each(data, function(i, subcat) {
                    html += `<option value="${subcat.id}">${subcat.name}</option>`;
                });
                $('#subcategorySelect').html(html);
            });
        });


        $('#stepOneForm').on('submit', function(e) {
            e.preventDefault();

            $.ajax({
                url: "{{ route('products.step.one') }}",
                type: "POST",
                data: $(this).serialize(),
                success: function(res) {

                    Swal.fire({
                        icon: 'success',
                        title: res.message,
                        timer: 1200,
                        showConfirmButton: false
                    });

                    // 🔥 Redirect to edit page (show)
                    setTimeout(() => {
                        window.location.href = "{{ url('get-product') }}/" + res.product_id;
                    }, 1200);
                },
                error: function(xhr) {
                    Swal.fire(
                        'Error',
                        xhr.responseJSON?.message || 'Validation error',
                        'error'
                    );
                }
            });
        });

    });
</script>


@endsection