@extends('admin.layout.template')

@section('title', 'Notifications')

@section('content')
<div class="page-content">
<div class="container-xxl">

    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">All Notifications</h5>

            @if($notifications->count())
                <form method="POST" action="{{ route('notifications.destroyAll') }}"
                      onsubmit="return confirm('Delete all notifications?')">
                    @csrf
                    @method('DELETE')
                   <button class="btn btn-sm btn-danger" id="deleteAllNotifications">
    Delete All
</button>

                </form>
            @endif
        </div>

        <div class="card-body p-0">

            @forelse($notifications as $notification)
                @php
                    $data = $notification->data;
                    $isUnread = is_null($notification->read_at);
                @endphp

                <div class="d-flex align-items-start p-3 border-bottom
                    {{ $isUnread ? 'bg-soft-light' : '' }}">

                    <!-- Icon -->
                    <div class="me-3">
                        <div class="avatar-sm">
                            <span class="avatar-title rounded-circle bg-soft-primary text-primary fs-20">
                                <iconify-icon icon="solar:bell-bing-bold-duotone"></iconify-icon>
                            </span>
                        </div>
                    </div>

                    <!-- Content -->
                    <div class="flex-grow-1">
                        <h6 class="mb-1 {{ $isUnread ? 'fw-bold' : '' }}">
                            {{ $data['title'] ?? 'System Notification' }}
                        </h6>

                        <p class="mb-1 text-muted">
                            {{ $data['message'] ?? '' }}
                        </p>

                        <small class="text-muted">
                            {{ $notification->created_at->diffForHumans() }}
                        </small>
                    </div>

                    <!-- Actions -->
                    <div class="ms-3 d-flex gap-2">

                        @if($isUnread)
                            <a href="{{ route('notifications.read', $notification->id) }}"
                               class="btn btn-sm btn-outline-primary"
                               title="Mark as read">
                                <i class="bx bx-check"></i>
                            </a>
                        @endif

                        <form method="POST"
                              action="{{ route('notifications.destroy', $notification->id) }}"
                              onsubmit="return confirm('Delete this notification?')">
                            @csrf
                            @method('DELETE')
                         <button class="btn btn-sm btn-outline-danger delete-notification"
        data-id="{{ $notification->id }}">
    <i class="bx bx-trash"></i>
</button>
                        </form>

                    </div>
                </div>

            @empty
                <div class="text-center py-5 text-muted">
                    No notifications available
                </div>
            @endforelse

        </div>

        <div class="card-footer">
            {{ $notifications->links() }}
        </div>
    </div>

</div>
</div>

<form id="deleteNotificationForm" method="POST" style="display:none;">
    @csrf
    @method('DELETE')
</form>

<form id="deleteAllNotificationsForm"
      method="POST"
      action="{{ route('notifications.destroyAll') }}"
      style="display:none;">
    @csrf
    @method('DELETE')
</form>
<script>
document.addEventListener('DOMContentLoaded', function () {

    // DELETE SINGLE NOTIFICATION
    document.querySelectorAll('.delete-notification').forEach(button => {
        button.addEventListener('click', function () {

            let notificationId = this.dataset.id;
            let form = document.getElementById('deleteNotificationForm');

            form.action = "{{ url('notifications') }}/" + notificationId;

            Swal.fire({
                title: 'Delete notification?',
                text: 'This action cannot be undone.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Yes, delete it',
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
        });
    });

    // DELETE ALL NOTIFICATIONS
    let deleteAllBtn = document.getElementById('deleteAllNotifications');

    if (deleteAllBtn) {
        deleteAllBtn.addEventListener('click', function () {

            Swal.fire({
                title: 'Delete all notifications?',
                text: 'All notifications will be permanently deleted.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Yes, delete all',
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('deleteAllNotificationsForm').submit();
                }
            });
        });
    }

});
</script>

@endsection
