<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class PermissionSeeder extends Seeder
{
    // public function run(): void
    // {
    //     $permissions = [

    //         // PROFILE
    //         'profile.edit',
    //         'profile.update',
    //         'profile.destroy',

    //         // ROOM
    //         'room.index',
    //         'get-room',
    //         'add-room',
    //         'update-room',
    //         'delete-room',

    //         // TAG
    //         'tag.index',
    //         'get-tag',
    //         'add-tag',
    //         'update-tag',
    //         'delete-tag',

    //         // CATEGORY
    //         'category.index',
    //         'get-category',
    //         'add-category',
    //         'update-category',
    //         'delete-category',

    //         // SUBCATEGORY
    //         'subcategory',
    //         'get-subcategory',
    //         'add-subcategory',
    //         'update-subcategory',
    //         'delete-subcategory',
    //         'toggle-subcategory-status',

    //         // PRODUCT
    //         'add-product',
    //         'products',
    //         'get-products',
    //         'product.store',
    //         'products.step.one',
    //         'product.step2.store',
    //         'product.images.store',
    //         'stocks.store',
    //         'products.step.one.update',
    //         'products.step.two.update',
    //         'products.step.three.update',
    //         'products.step.four.update',
    //         'products.image.delete',

    //         // BANNER
    //         'banner',
    //         'get-banner',
    //         'add-banner',
    //         'banner.status',

    //         // COUPON
    //         'coupons',
    //         'get-coupons',
    //         'add-coupon',
    //         'coupon.update',
    //         'coupon.status',

    //         // STOCK
    //         'stock.index',
    //         'stock.list',
    //         'stock.view',
    //         'stock.edit',

    //         // LOCATION
    //         'locations',
    //         'get-locations',
    //         'add-locations',
    //         'update-locations',
    //         'delete-locations',

    //         // ROLES
    //         'roles.index',
    //         'roles.create',
    //         'roles.store',
    //         'roles.edit',
    //         'roles.update',
    //         'roles.destroy',

    //         // USERS
    //         'users.index',
    //         'users.store',
    //         'users.edit',
    //         'users.update',
    //         'users.destroy',
    //     ];

    //     foreach ($permissions as $permission) {
    //         Permission::firstOrCreate([
    //             'name' => $permission,
    //             'guard_name' => 'web',
    //         ]);
    //     }

    //     // 🔑 ROLES
    //     $admin = Role::firstOrCreate(['name' => 'Super Admin']);
    //     $masterFranchise = Role::firstOrCreate(['name' => 'Master Franchise Owner']);
    //     $franchise = Role::firstOrCreate(['name' => 'Franchise Owner']);

    //     // ✅ Super Admin → ALL
    //     $admin->syncPermissions(Permission::all());

    //     // ✅ Master Franchise → View only
    //     $masterFranchise->syncPermissions([
    //         'category.index',
    //         'subcategory',
    //         'products',
    //         'stock.index',
    //         'locations',
    //         'banner',
    //         'coupons',
    //     ]);

    //     // ✅ Franchise Owner → Limited CRUD
    //     $franchise->syncPermissions([
    //         'products',
    //         'product.store',
    //         'products.step.one.update',
    //         'stock.index',
    //         'stock.edit',
    //         'coupons',
    //     ]);
    // }
     public function run(): void
    {
        $permissions = [
        // 'coupon-delete',
        // 'edit-coupon'
        // 'banner.status',
        // 'department-status',
        // 'departments',
        //  'add-department',
        //   'update-department',
        //    'delete-department',
            // 'brand.index',
            //  'add-brand',
            //  'delete-brand',
            //  'update-brand',
          //  'users.store',
          'roles.store',
          'roles.update'
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate([
                'name' => $permission,
                'guard_name' => 'web',
            ]);
        }

        // 🔑 ROLES
        $admin = Role::firstOrCreate(['name' => 'Super Admin']);
       

        // ✅ Super Admin → ALL
        $admin->syncPermissions(Permission::all());

    }
}
