<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stocks', function (Blueprint $table) {
            $table->id();

            $table->foreignId('product_variant_id')->constrained();
            $table->foreignId('location_id')->constrained();

            $table->decimal('available_qty', 10, 2);
            $table->decimal('reserved_qty', 10, 2)->default(0);

            $table->decimal('reorder_level', 10, 2)->nullable();
            $table->boolean('is_available')->default(true);

            $table->timestamps();

            $table->unique(['product_variant_id', 'location_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stocks');
    }
};
