<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Schema::create('locations', function (Blueprint $table) {
        //     $table->id();
        //     $table->string('name'); // Warehouse / Franchise / Store
        //     $table->enum('type', ['Warehouse', 'Franchise', 'Store']);
        //     $table->timestamps();
        // });
        Schema::create('locations', function (Blueprint $table) {
            $table->id();

            /* -----------------------------
     | Basic Location Info
     |-----------------------------*/
            $table->string('location_code')->unique(); // Auto-generated
            $table->string('name'); // Location / Business Name
            $table->string('display_name')->nullable(); // Short name for app

            $table->enum('type', [
                'Warehouse',
                'Franchise',
                'Zonal Franchise',
                'Distributor',
                'Dealer / Showroom',
                'Office / Branch'
            ]);

            /* -----------------------------
     | Address Details
     |-----------------------------*/
            $table->string('city')->nullable();
            $table->string('district')->nullable();
            $table->string('state')->nullable();
            $table->string('country')->nullable();
            $table->string('pincode', 10)->nullable();

            /* -----------------------------
     | Contact Details
     |-----------------------------*/
            $table->string('contact_person_name')->nullable();
            $table->string('phone', 20)->nullable();
            $table->string('alternate_phone', 20)->nullable();
            $table->string('email')->nullable();

            /* -----------------------------
     | Legal & Billing Details
     |-----------------------------*/
            $table->string('gst_number')->nullable();
            $table->string('pan')->nullable();
            $table->string('trade_license_no')->nullable();

            $table->string('billing_name')->nullable();
            $table->text('billing_address')->nullable();

            /* -----------------------------
     | Reporting Structure
     |-----------------------------*/
            $table->foreignId('reporting_location_id')
                ->nullable()
                ->constrained('locations')
                ->nullOnDelete();

            /* -----------------------------
     | Status
     |-----------------------------*/
            $table->enum('status', [
                'Active',
                'Temporarily Closed',
                'Inactive'
            ])->default('Active');

            /* -----------------------------
     | Audit Fields
     |-----------------------------*/
            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();
            $table->foreignId('updated_by')->nullable()->constrained('users')->nullOnDelete();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('locations');
    }
};
