<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        //         Schema::create('product_variants', function (Blueprint $table) {
        //             $table->id();

        //             $table->foreignId('product_id')->constrained()->cascadeOnDelete();

        //             // SKU & identity
        //             $table->string('sku');
        // $table->unique(['product_id', 'sku']);
        //             $table->string('batch_no')->nullable();

        //             // Pricing
        //             $table->decimal('mrp', 10, 2);
        //             $table->decimal('offer_price', 10, 2);

        //             // Unit & measurement
        //             $table->string('unit');
        //             // cm, inch, feet, running_feet, sqrfeet, set, nos, box

        //             $table->json('dimensions')->nullable();
        //             /*
        //       {
        //         "length":120,
        //         "width":60,
        //         "height":73,
        //         "unit":"cm"
        //       }
        //     */

        //             // Color
        //             $table->string('color_name')->nullable(); // Ivory
        //             $table->string('color_code')->nullable(); // HEX / RGB

        //             // Fabric / technical
        //             $table->string('fabric_composition')->nullable(); // Cotton 60% + Polyester 40%
        //             $table->decimal('gsm', 8, 2)->nullable();
        //             $table->decimal('weight', 8, 2)->nullable();
        //             $table->integer('rub_count')->nullable();

        //             // MOQ
        //             $table->integer('moq')->nullable();

        //             $table->boolean('is_active')->default(true);
        //             $table->timestamps();
        //         });

        Schema::create('product_variants', function (Blueprint $table) {
            $table->id();

            $table->foreignId('product_id')
                ->constrained()
                ->cascadeOnDelete();

            // SKU & identity
            $table->string('sku'); // NOT unique alone
            $table->string('batch_no')->nullable();

            // Pricing
            $table->decimal('mrp', 10, 2);
            $table->decimal('offer_price', 10, 2);

            // Unit & measurement
            $table->string('unit');

            $table->json('dimensions')->nullable();

            // Color
            $table->string('color_name')->nullable();
            $table->string('color_code')->nullable();
             $table->string('pattern')->nullable(); 
            // Fabric / technical
            $table->string('material_or_fabric_composition')->nullable();
            $table->decimal('gsm', 8, 2)->nullable();
            $table->decimal('weight', 8, 2)->nullable();
            $table->integer('rub_count')->nullable();

            // MOQ
            $table->integer('moq')->nullable();

            $table->boolean('is_active')->default(true);
            $table->timestamps();

            // 🔥 Composite Unique Constraint
            $table->unique(['product_id', 'sku']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('product_variants');
    }
};
